﻿<%@ Page Title="Feedback Reports" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="FeedbackReports.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.FeedbackReports" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 

<script>
    var checkdates = 1;

    $(document).ready(function () {
        var alllessons = getUrlVars()["all"];
        if (alllessons == "true") {
            document.getElementById("queryselect").value = 1;
            document.getElementById("alllessons").style.display = "inline";
            document.getElementById("tablediv").style.visibility = "visible";
        }

        var lessid = getUrlVars()["lessid"];
        if (lessid != undefined) {
            //alert(lessid);
            document.getElementById("queryselect").value = 2;
            document.getElementById("bylesson").style.display = "inline";
            const myData = JSON.parse("[" + lessid + "]");
            setTimeout(function () {
                $('#lessonsel').select2();
                $('#lessonsel').select2().val(myData);
                $('#lessonsel').select2().trigger('change');
            }, 0);
            document.getElementById("tablediv").style.visibility = "visible";
        }

        var feedbacktypeid = getUrlVars()["feedbacktypeid"];        
        if (feedbacktypeid != undefined) {
            document.getElementById("queryselect").value = 3;
            document.getElementById("byfeebacktype").style.display = "inline";
            document.getElementById("feedback_types").value = feedbacktypeid;
            document.getElementById("tablediv").style.visibility = "visible";
        }

        var startdate = getUrlVars()["startdate"]; 
        var enddate = getUrlVars()["enddate"]; 
        if (startdate != undefined) {
            document.getElementById("queryselect").value = 4;
            document.getElementById("bydaterange").style.display = "inline";
            document.getElementById("start_date").value = startdate;
            document.getElementById("end_date").value = enddate;
            document.getElementById("tablediv").style.visibility = "visible";
        }

        var tcprequested = getUrlVars()["tcp"]; 
        if (tcprequested != undefined) {
            document.getElementById("queryselect").value = 5;
            document.getElementById("bytcp").style.display = "inline";
            document.getElementById("tcpselect").value = tcprequested;  
            document.getElementById("tablediv").style.visibility = "visible";
        }

        $("#lessonsel").select2(); 

        $(function () {
            $("#start_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#end_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $('#example').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": true,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Feedback"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });  
    });

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function selectquery() {
        var e = document.getElementById("queryselect");
        var value = e.value;

        if (value == 1) {
            document.getElementById("alllessons").style.display = "inline";
            document.getElementById("bylesson").style.display = "none";
            document.getElementById("byfeebacktype").style.display = "none";
            document.getElementById("bydaterange").style.display = "none";
            document.getElementById("bytcp").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
        else if (value == 2) {
            document.getElementById("bylesson").style.display = "inline";
            document.getElementById("alllessons").style.display = "none";
            document.getElementById("byfeebacktype").style.display = "none";
            document.getElementById("bydaterange").style.display = "none";
            document.getElementById("bytcp").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
        else if (value == 3) {
            document.getElementById("byfeebacktype").style.display = "inline";
            document.getElementById("bylesson").style.display = "none";
            document.getElementById("alllessons").style.display = "none";
            document.getElementById("bydaterange").style.display = "none";
            document.getElementById("bytcp").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
        else if (value == 4) {
            document.getElementById("bydaterange").style.display = "inline";
            document.getElementById("bylesson").style.display = "none";
            document.getElementById("byfeebacktype").style.display = "none";
            document.getElementById("alllessons").style.display = "none";
            document.getElementById("bytcp").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
        else if (value == 5) {
            document.getElementById("bytcp").style.display = "inline";
            document.getElementById("bylesson").style.display = "none";
            document.getElementById("byfeebacktype").style.display = "none";
            document.getElementById("bydaterange").style.display = "none";
            document.getElementById("alllessons").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
        else { //value = 0
            document.getElementById("alllessons").style.display = "none";
            document.getElementById("bylesson").style.display = "none";
            document.getElementById("byfeebacktype").style.display = "none";
            document.getElementById("bydaterange").style.display = "none";
            document.getElementById("bytcp").style.display = "none";
            document.getElementById("tablediv").style.visibility = "hidden";
        }
    }

    function alllessonsreport() {
        window.location.href = "../CAT/FeedbackReports.aspx?all=true"; 
    }

    function lessonreport() {
        var e = document.getElementById("lessonsel");
        var value = e.value;
        if (value == 0) {
            alert("Lesson(s) field is required.");
            return false;
        }
        var values = $('#lessonsel').val();
        //alert(values);
        window.location.href = "../CAT/FeedbackReports.aspx?lessid=" + values; 
    }

    function feedbacktypereport() {
        var e = document.getElementById("feedback_types");
        var value = e.value;  
        if (value == 0) {
            alert("Feedback Type field is required.");
            return false;
        }
        window.location.href = "../CAT/FeedbackReports.aspx?feedbacktypeid=" + value;       
    }

    function rangedatereport() {
        var e = document.getElementById("start_date");
        var startdate = e.value;

        var f = document.getElementById("end_date");
        var enddate = f.value;

        if (startdate == "") {
            alert("Start Date field is required.");
            return false;
        }
        if (enddate == "") {
            alert("End Date field is required.");
            return false;
        }  
        //alert(checkdates);
        if (checkdates == 0) {
            window.location.href = "../CAT/FeedbackReports.aspx?startdate=" + startdate + "&enddate=" + enddate;
        }
        else {
            alert("ERROR: Dates must be valid!");
            return false;
        }
        
    }

    function tcpreport() {
        var e = document.getElementById("tcpselect");
        var value = e.value;
        if (value == "") {
            alert("TCP Requested field is required.");
            return false;
        }
        window.location.href = "../CAT/FeedbackReports.aspx?tcp=" + value;
    }

    function checkstartdate() {          
        var e = document.getElementById("start_date");
        var startdate = e.value;

        var f = document.getElementById("end_date");
        var enddate = f.value;

        if (startdate != "" && enddate != "") {
            if (startdate > enddate) {
                alert("Error: Start Date must come before End Date.");
                document.getElementById("end_date").value = "";
            }
        }

        if (startdate == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(startdate)) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }

            // Parse the date parts to integers
            var parts = startdate.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }
        }

        if (enddate == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(enddate)) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }

            // Parse the date parts to integers
            var parts = enddate.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }
        }

        checkdates = 0;
    }

    function checkenddate() {
        var e = document.getElementById("start_date");
        var startdate = e.value;

        var f = document.getElementById("end_date");
        var enddate = f.value;

        if (startdate != "" && enddate != "") {
            if (startdate > enddate) {
                alert("Error: Start Date must come before End Date.");
                document.getElementById("start_date").value = "";                
            }
        }

        if (startdate == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(startdate)) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }

            // Parse the date parts to integers
            var parts = startdate.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }
        }

        if (enddate == "") {
            //do nothing
        }
        else {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(enddate)) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }

            // Parse the date parts to integers
            var parts = enddate.split("/");
            var month = parseInt(parts[0], 10);
            var year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                alert("ERROR: Date must be valid!");
                checkdates = 1;
                return false;
            }
        }       

        checkdates = 0;
    }

    function exportexcel() {        
        var alllessons = getUrlVars()["all"];
        if (alllessons == "true") {
            window.location.href = "../CAT/ExportFeedbackReports.aspx?all=true"; 
        }

        var lessid = getUrlVars()["lessid"];  
        if (lessid != undefined) {         
            window.location.href = "../CAT/ExportFeedbackReportsLessons.aspx?lessid=" + lessid; 
        }

        var feedbacktypeid = getUrlVars()["feedbacktypeid"];
        if (feedbacktypeid != undefined) {
            window.location.href = "../CAT/ExportFeedbackReports.aspx?feedbacktypeid=" + feedbacktypeid;  
        }

        var startdate = getUrlVars()["startdate"];
        var enddate = getUrlVars()["enddate"];
        if (startdate != undefined) {
            window.location.href = "../CAT/ExportFeedbackReports.aspx?startdate=" + startdate + "&enddate=" + enddate; 
        }

        var tcprequested = getUrlVars()["tcp"];
        if (tcprequested != undefined) {
            window.location.href = "../CAT/ExportFeedbackReports.aspx?tcp=" + tcprequested;
        }
    }
</script>

<style>
.reporttype{
    text-align: center;
    width: 450px;
    background-color: navajowhite;
    margin: auto;
    border: 2px solid black;
    padding: 10px;
    border-radius: 20px;
}
.select2-search__field {
    color: black;
}
#queryselect{
    font-size: 18px;
}
#tcpselect{
    font-size: 18px;
}
#start_date{
    font-size: 18px;
    width: 120px;
}
#end_date{
    font-size: 18px;
    width: 120px;
}
#feedback_types{
    font-size: 18px;
}
</style>
<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Feedback Reports</h1></div>
<hr />
<br />
<div class="reporttype">
    <select id="queryselect" onchange="selectquery();">
        <option value="0">Select Query Type</option>
        <option value="1">Search All Lessons</option>
        <option value="2">Search By Lesson(s)</option>        
        <option value="3">Search By Feedback Type</option>
        <option value="4">Search By Date Range</option>
        <option value="5">Search By TCP Requested</option>
    </select>

    <div id="alllessons" style="display: none;">
        <br /><br />
        <b>Search All Lessons</b><br /><br />
        <button class="button" onclick="alllessonsreport();">Submit</button>
    </div>

    <div id="bylesson" style="display: none;">
        <br /><br />
        <b>Search By Lesson(s)</b><br /><br />
        <select id="lessonsel" style="width: 400px;" multiple>
            <asp:Label ID="Label2" runat="server" />
        </select>
        <br /><br />
        <button class="button" onclick="lessonreport();">Submit</button> 
    </div>

    <div id="byfeebacktype" style="display: none;">
        <br /><br />
        <b>Search By Feedback Type</b><br /><br />   
        <select id="feedback_types" style="width: 400px;">
            <asp:Label ID="Label1" runat="server" />
        </select>
        <br /><br />
        <button class="button" onclick="feedbacktypereport();">Submit</button>       
    </div>

    <div id="bydaterange" style="display: none;">
        <br /><br />
        <b>Search By Date Range</b><br /><br />
        <input id="start_date" name="start_date" type="text" placeholder="Start Date" style="color: black" autocomplete="off" onchange="checkenddate();" />
        <input id="end_date" name="end_date" type="text" placeholder="End Date" style="color: black" autocomplete="off" onchange="checkstartdate();" />
        <br /><br />
        <button class="button" onclick="rangedatereport();">Submit</button> 
    </div>

    <div id="bytcp" style="display: none;">
        <br /><br />
        <b>Search By TCP Requested</b><br /><br />
        <select id="tcpselect">
            <option value="">TCP Requested</option>
            <option value="0">No</option>
            <option value="1">Yes</option>
        </select>
        <br /><br />
        <button class="button" onclick="tcpreport();">Submit</button>
    </div>
</div>

<div id="tablediv" style="visibility:hidden; margin: 35px;">
 <img src="../images/excel.png" style="width: 32px; height: 30px; cursor: pointer" title="Export to Excel" onclick="exportexcel();" />
    <table id="example" class="display" style="border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th style="width: 100px; min-width: 100px;">Lesson</th>
                <th style="width: 50px; min-width: 50px;">Feedback Date</th>   
                <th style="width: 100px; min-width: 100px;">Feedback Type</th> 
                <th style="width: 100px; min-width: 100px;">Primary Instructor</th> 
                <th style="width: 100px; min-width: 100px;">Alternate Instructor</th> 
                <th style="width: 50px; min-width: 50px;">TCP Requested</th> 
                <th style="width: 400px; min-width: 400px;">Comments</th>  
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label3" runat="server" />                          
        </tbody>
    </table>
</div>

</asp:Content>
