﻿<%@ Page Title="Smartsheet Projects" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="Projects.aspx.cs" Inherits="CAE_WEB_PROJECT.admin.Projects" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 

<script>
    var Project_Name;
    var selid;

    $(document).ready(function () {
        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Smartsheet Projects"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                var data = table.row(this).data();
                savedata(data);
            }
        });       
    }); 

    function savedata(rowdata) {
        Project_Name = rowdata[3];
        selid = rowdata[4];       
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var modalcheck = document.getElementById("myModal2");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                }
            };

            $('#editid').val(selid);
            $('#editprojectname').val(Project_Name);          
        }        
    }

    function createproject() {
        var modalcheck = document.getElementById("myModal");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal2");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close2")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to delete this project? This will permanently delete all tasks for this project.") == true) {
                window.location.href = "../admin/deleteproject.aspx?selid=" + selid;
            } else {
                return;
            }            
        }
    }
</script>

<style>
.profilediv {
    display: table;
}

#profilespan {
    display: table-cell;
    vertical-align: middle;
    width: 100%;
}
</style>

<div style="width: 100%; min-width: 850px;"> 
<br /><br />
<div style="text-align: center; font-family:sans-serif;"><h1>Smartsheet Projects</h1></div>
<hr />
<div style="margin: 35px; min-width: 500px;">
<button class="button" onclick="createproject()">Create Project</button>
<button class="button" onclick="editdata()">Rename Project</button>
<button class="button" onclick="deletedata()">Delete Project</button>

<div style="float: right;">
<button class="button" onclick="window.location.href='../admin/Phases.aspx';">Phases</button>
<button class="button" onclick="window.location.href='../admin/Tasks.aspx';">Tasks</button>
<button class="button" onclick="window.location.href='../admin/Status.aspx';">Status</button>
</div>

<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>Project Name</th>
                <th>Created By</th>
                <th>Creation Date</th>  
                <th>Project Status</th>  
                <th>Completion Date</th> 
                <th>Total Days Assigned</th>  
                <th>Total Hours to Complete Tasks</th> 
                <th style="display:none;">Project Name</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            <asp:Label ID="Label1" runat="server" />                          
        </tbody>
    </table>
</div>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Rename Project</h4><br />
       <form class="form login" name="form1" action="../admin/editproject.aspx" method="post" enctype="multipart/form-data" onsubmit="return checkEmail(this)">
       <input type="hidden" name="editid" id="editid" />   
       <div class="form__field">
       <input style="color: white" type="text" name="editprojectname" id="editprojectname" placeholder="Project Name" required="required"/>
       </div>
       <div class="form__field">
       <input type="submit" value="Update" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Create Project</h4><br />
       <form class="form login" name="form1" action="../admin/addproject.aspx" method="post" enctype="multipart/form-data">
       <div class="form__field">
       <input style="color: white" type="text" name="projectname" id="projectname" placeholder="Project Name" required="required"/>
       </div>
       <div class="form__field">
       <input type="submit" value="Create Project" />
       </div>          
       </form>
  </div>
</div>

</asp:Content>
