﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT.Reports
{
    public partial class SOIReport3 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("ALLSOILESSINFO");

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/ALLSOILESSINFO.xlsx"));

                //Add header row columns name in string list array
                var headerRow = new List<string[]>()
                  {
                    new string[] { "SOISTATUS", "SOITITLE", "SOIDATE", "LESSSTATUS", "LESSNUMBER", "LESSTITLE", "LESSREV", "REVDATE", "FEADATE", "MEDIAlku", "CLASSIFICATION" }                  
                  };

                // Get the header range
                string Range = "A1:" + Char.ConvertFromUtf32(headerRow[0].Length + 64) + "1";

                // get the workSheet in which you want to create header
                var worksheet = excel.Workbook.Worksheets["ALLSOILESSINFO"];

                // Popular header row data
                worksheet.Cells[Range].LoadFromArrays(headerRow);

                int rowcounter = 2;         
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();
                SqlCommand cmd = new SqlCommand("select stat.status as SOISTATUS, s.SOITITLE, CONVERT(varchar,s.SOIDATE,101) as SOIDATE, stat2.status as LESSSTATUS, l.LESSNUMBER, l.LESSTITLE, rev.rev as LESSREV, CONVERT(varchar,l.REVDATE,101) as " +
                    "REVDATE, CONVERT(varchar,l.FEADATE,101) as FEADATE, media.media as MEDIAlku, class.CLASSIFICATION from soi s, lesson l, soiless sl, statusiku stat, statusiku stat2, classification class, reviku rev, mediaiku media where " +
                    "l.lessid = sl.lessidfk and s.soiid = sl.soiidfk and s.soistatus=stat.id and l.status=stat2.id and l.classification=class.classid and l.lessrev=rev.id and l.mediaiku=media.id and l.MP!=1 order by s.soiid");
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string SOISTATUS = reader["SOISTATUS"].ToString();                        
                        string SOITITLE = reader["SOITITLE"].ToString();                        
                        string SOIDATE = reader["SOIDATE"].ToString();
                        string LESSSTATUS = reader["LESSSTATUS"].ToString();
                        string LESSNUMBER = reader["LESSNUMBER"].ToString();
                        string LESSTITLE = reader["LESSTITLE"].ToString();
                        string LESSREV = reader["LESSREV"].ToString();                        
                        string REVDATE = reader["REVDATE"].ToString();
                        string FEADATE = reader["FEADATE"].ToString();
                        string MEDIAlku = reader["MEDIAlku"].ToString();
                        string CLASSIFICATION = reader["CLASSIFICATION"].ToString();
                        //Table Rows
                        //Now add some data in rows for each column
                        
                        var Data = new List<object[]>()
                            {
                              new object[] {SOISTATUS,SOITITLE,SOIDATE,LESSSTATUS,LESSNUMBER,LESSTITLE,LESSREV,REVDATE,FEADATE,MEDIAlku,CLASSIFICATION},                              
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);

                        //For some reason autofitcolumns was breaking this report, so I used column width instead
                        worksheet.DefaultColWidth = 15;
                        worksheet.Column(2).Width = 40;
                        worksheet.Column(5).Width = 50;
                        worksheet.Column(6).Width = 50;                       
                        rowcounter++;
                    }
                }
                con.Dispose();

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/ALLSOILESSINFO.xlsx"));
            Response.Redirect("../files/ALLSOILESSINFO.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}