                            !     e                 
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />
<meta http-equiv='cache-control' content='no-cache'>
<meta http-equiv='expires' content='0'>
<meta http-equiv='pragma' content='no-cache'>
<script>
    $(document).ready(function () {
        $("#selSOI").select2();  
        createTable();
    });

    var removerowcounter = 0;
    var removedrow = 0;

    // Start ---> Must keep this code here even though it isn't really being used
    let arrHead = new Array();
    arrHead = ['', 'Day', 'Lesson', 'Duration', 'Pre Brief', 'Post Brief', '# of Missions', 'Pilot', 'Pilot Prereqs', 'CSO', 'CSO Prereqs', 'SMA', 'SMA Prereqs', 'LM', 'LM Prereqs'];      // table headers.

    // first create a TABLE structure by adding few headers.
    let createTable = () => {
        let empTable = document.createElement('table');
        empTable.setAttribute('id', 'empTable');  // table id.       
        let tr = empTable.insertRow(-1);
        for (let h = 0; h < arrHead.length; h++) {            
            let th = document.createElement('th'); // the header object.
            tr.setAttribute('id', 'tableheader');
            th.setAttribute('class', 'column' + h);
            th.innerHTML = arrHead[h];
            th.style.backgroundColor = "#005EB8";
            th.style.color = "white"; 
            //tr.appendChild(th);  //Removed the header because it was not working properly with drag and drop
        }

        let div = document.getElementById('cont');
        div.appendChild(empTable);    // add table to a container.
    }
    // End ---> Must keep this code here even though it isn't really being used

    // function to add new row.
    let addRow = () => {   
        document.getElementById("multirowsdiv").style.display = "none";
        document.getElementById('addRow').style.backgroundColor = "transparent"; 
        document.getElementById('addRow').style.color = "black";   
        document.getElementById("addRow").addEventListener("mouseover", function () {
            document.getElementById("addRow").style.backgroundColor = "#005EB8";
            document.getElementById("addRow").style.color = "white";
        });

        document.getElementById("addRow").addEventListener("mouseout", function () {
            document.getElementById("addRow").style.backgroundColor = "transparent";
            document.getElementById("addRow").style.color = "black";
        });       

        let empTab = document.getElementById('empTable');
        empTab.setAttribute('class', 'table-dragable');
        let rowCnt = empTab.rows.length;    // get the number of rows.
        
        if (removerowcounter != 0) {  
            //alert(removerowcounter);
            for (let j = 0; j <= rowCnt; j++) {
                if ($('#rownumber' + j).length === 0) {
                    //alert("Row " + j + " added.");
                    rowCnt = j;
                }
                else {
                    //alert("Row " + j + " already exists.");
                }
            }
            removerowcounter = removerowcounter - 1;
        }        

        let tr = empTab.insertRow(rowCnt); // table row.
        tr.setAttribute('id', 'rownumber' + rowCnt);
        tr.setAttribute('class', 'grabable');        

        $('.table-dragable tbody .grabable').mousedown(function (e) {
            var tr = $(e.target).closest('tr'), sy = e.pageY, drag;
            if ($(e.target).is('tr')) tr = $(e.target);
            var index = tr.index();           
            $(tr).addClass('grabbed');
            function move(e) {
                if (!drag && Math.abs(e.pageY - sy) < 10) return;                
                drag = true;
                tr.siblings().each(function () {
                    var s = $(this), i = s.index(), y = s.offset().top;
                    if (e.pageY >= y && e.pageY < y + s.outerHeight()) {
                        if (i < tr.index()) {
                            s.insertAfter(tr);                          
                        }
                        else {
                            s.insertBefore(tr);   
                        }
                        return false;
                    }
                });
            }
            function up(e) {
                if (drag && index != tr.index()) {
                    drag = false;
                }
                $(document).unbind('mousemove', move).unbind('mouseup', up);
                $(tr).removeClass('grabbed');
            }
            $(document).mousemove(move).mouseup(up);
        });

        for (let c = 0; c < arrHead.length; c++) {
            let td = document.createElement('td');          // table definition.           
            td = tr.insertCell(c);

            if (c == 0) {   // if its the first column of the table.
                // add a button control.
                const button = document.createElement('input');

                // set the attributes.
                if (rowCnt != 0) {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('onclick', 'removeRow(this)');
                    td.appendChild(button);
                }
                else {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('style', 'visibility: hidden');
                    td.appendChild(button);
                }
            }
            else if (c == 1) {
                // 2nd column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '1');
                ele.setAttribute('id', 'day' + rowCnt);
                ele.setAttribute('class', 'dayinput');
                //alert(rowCnt);
                if (rowCnt == 0) {
                    ele.setAttribute('value', '1');
                    ele.setAttribute('readonly', 'readonly');
                }
                else {
                    ele.setAttribute('value', '');
                }
                td.appendChild(ele);
            }
            else if (c == 2) {
                // 3rd column will have dropdown
                const ele = document.createElement('select');
                ele.setAttribute('class', 'lessonselect');
                ele.setAttribute('id', 'lessonsel' + rowCnt);
                ele.value = "Select Lesson";
                ele.add(new Option("Select Lesson"));
                ele.setAttribute('onchange', 'checkmediatype(' + rowCnt + ')');
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        //option.text = optvalue[1] + " <" + optvalue[0] + ">";
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".lessonselect").select2();
            }
            else if (c == 3) {
                // 4th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'durationinput');
                ele.setAttribute('id', 'duration' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 4) {
                // 5th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'prebriefinput');
                ele.setAttribute('id', 'prebrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 5) {
                // 6th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'postbriefinput');
                ele.setAttribute('id', 'postbrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 6) {
                // 7th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'missioninput');
                ele.setAttribute('id', 'mission' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 7) {
                // 8th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "Pilot";
                checkbox.value = "Pilot";
                checkbox.id = "Pilot" + rowCnt; 
                checkbox.setAttribute('class', 'cbclass');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' Pilot '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 8) {
                // 9th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(8).setAttribute("id", "pilottd" + rowCnt);
                ele.setAttribute('class', 'pilotprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'pilotprereq' + rowCnt);
                ele.setAttribute('onchange', 'Pilotprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".pilotprereqsel").select2({
                    placeholder: "Select Pilot Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#pilotprereq' + rowCnt).select2();
                    $('#pilotprereq' + rowCnt).select2().val("None");
                    $('#pilotprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 9) {
                // 10th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "CSO";
                checkbox.value = "CSO";
                checkbox.id = "CSO" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateCSO(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' CSO '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 10) {
                // 11th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(10).setAttribute("id", "csotd" + rowCnt);
                ele.setAttribute('class', 'csoprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'csoprereq' + rowCnt);
                ele.setAttribute('onchange', 'CSOprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".csoprereqsel").select2({
                    placeholder: "Select CSO Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#csoprereq' + rowCnt).select2();
                    $('#csoprereq' + rowCnt).select2().val("None");
                    $('#csoprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 11) {
                // 12th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "SMA";
                checkbox.value = "SMA";
                checkbox.id = "SMA" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateSMA(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' SMA '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 12) {
                // 13th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(12).setAttribute("id", "smatd" + rowCnt);
                ele.setAttribute('class', 'smaprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'smaprereq' + rowCnt);
                ele.setAttribute('onchange', 'SMAprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".smaprereqsel").select2({
                    placeholder: "Select SMA Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#smaprereq' + rowCnt).select2();
                    $('#smaprereq' + rowCnt).select2().val("None");
                    $('#smaprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 13) {
                // 14th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "LM";
                checkbox.value = "LM";
                checkbox.id = "LM" + rowCnt;  
                checkbox.setAttribute('class', 'cbclass');                
                var label = document.createElement('label');         
                label.appendChild(document.createTextNode(' LM '));
                label.setAttribute('class', 'checkboxlabels');                 
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 14) {
                // 15th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(14).setAttribute("id", "lmtd" + rowCnt);
                ele.setAttribute('class', 'lmprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'lmprereq' + rowCnt);
                ele.setAttribute('onchange', 'LMprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));         
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);                       
                    }
                });
                td.appendChild(ele);       
                $(".lmprereqsel").select2({
                    placeholder: "Select LM Prereqs"
                });  
                /*
                setTimeout(function () {
                    $('#lmprereq' + rowCnt).select2();
                    $('#lmprereq' + rowCnt).select2().val("None");
                    $('#lmprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }  
        }
    }

    // function to delete a row.
    let removeRow = (oButton) => {
        let empTab = document.getElementById('empTable');        
        removedrow = oButton.parentNode.parentNode.rowIndex;
        //alert(removedrow);
        empTab.deleteRow(oButton.parentNode.parentNode.rowIndex); // buttton -> td -> tr
        removerowcounter++;
    }

    // function to extract and submit table data.
    let submit = () => {
        let myTab = document.getElementById('empTable');
        let arrValues = new Array();        
    
        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {               
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {    
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id); 
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                      
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(nodeid);
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }  
                                //alert(values);
                                arrValues.push(values);         
                            }                            
                            else if (cell.childNodes[0].type == 'checkbox') {
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                     
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";                               
                                var SMA = "False";
                                var LM = "False";
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }                            
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }                            
                        }                            
                        else {
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }

        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");       
        //alert(arrValues);
                
        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }       

        var soiid = document.getElementById('selSOI').value;   
        $('#tabledata').val(arrValues);
        $('#soiid').val(soiid);
        document.getElementById("savedata").submit(); // Submitting form
    }

    // function to extract and submit table data.
    let submit2 = () => {
        let myTab = document.getElementById('empTable');
        let arrValues = new Array();

        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id); 
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(nodeid);
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }
                                //alert(values);
                                arrValues.push(values);
                            }
                            else if (cell.childNodes[0].type == 'checkbox') {
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');               
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";
                                var SMA = "False";
                                var LM = "False";
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }
                        }
                        else {                        
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }

        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");
        //alert(arrValues);

        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }     
    
        var soiid = document.getElementById('selSOI').value;    
        $('#templatetabledata').val(arrValues);        
        $('#templatesoiid').val(soiid);
       
        document.getElementById("savetemplate").submit(); // Submitting form
    }

    function loadsoitable() {
        var timeoutvalue = 1000;
        var dropdownid = document.getElementById('selSOI').value;        
        $("#empTable tr").remove();         
        document.getElementById("notemplate").style.display = "none";
        document.getElementById("yestemplate").style.display = "none";
        //use get method to get the template data for the soi selected      
        $.get("../SOITable/gettemplatedata.aspx?soiid=" + dropdownid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];           
            //alert(data);
            if (data == 0) {                
                //No template for this SOI
                document.getElementById("notemplate").style.display = "inline";
                document.getElementById("multirowsdiv").style.display = "inline";
                $('#bt2').val("Save New Template");
            }
            else {                
                //Populate table with template
                //alert(data);
                const myData = data.split("^");              
                const myData2 = data.split("^"); 
                const myData3 = data.split("^"); 
                const myData4 = data.split("^");
                //alert(myData.length);
                if (myData.length <= 10) {
                    timeoutvalue = 1000;
                }
                else if (myData.length > 10 && myData.length <= 15) {
                    timeoutvalue = 2000;
                }
                else if (myData.length > 15 && myData.length <= 20) {
                    timeoutvalue = 3000;
                }
                else if (myData.length > 20 && myData.length <= 25) {
                    timeoutvalue = 4000;
                }
                else if (myData.length > 25 && myData.length <= 30) {
                    timeoutvalue = 5000;
                }
                else if (myData.length > 30 && myData.length <= 35) {
                    timeoutvalue = 6000;
                }
                else if (myData.length > 35 && myData.length <= 40) {
                    timeoutvalue = 7000;
                }
                else if (myData.length > 40 && myData.length <= 45) {
                    timeoutvalue = 8000;
                }
                else if (myData.length > 45 && myData.length <= 50) {
                    timeoutvalue = 15000;
                }
                else if (myData.length > 50 && myData.length <= 55) {
                    timeoutvalue = 16000;
                }
                else if (myData.length > 55 && myData.length <= 60) {
                    timeoutvalue = 17000;
                }
                else if (myData.length > 60 && myData.length <= 65) {
                    timeoutvalue = 18000;
                }
                else if (myData.length > 65 && myData.length <= 70) {
                    timeoutvalue = 19000;
                }
                else if (myData.length > 70 && myData.length <= 75) {
                    timeoutvalue = 20000;
                }
                else if (myData.length > 75 && myData.length <= 80) {
                    timeoutvalue = 21000;
                }
                else {  //myData.length > 80
                    timeoutvalue = 22000;
                }
                //alert(timeoutvalue);

                for (let i = 0; i < myData.length - 1; i++) {                    
                    //alert(myData[i]);
                    var optdata = myData[i];
                    const optvalue = optdata.split("~");
                    //alert(optvalue[0]);
                    //alert(optvalue[1]);
                    addRow();
                    $('#day' + i).val(optvalue[0]); 
                    setTimeout(function () {
                        $('#lessonsel' + i).select2();
                        $('#lessonsel' + i).select2().val(optvalue[1]);
                        $('#lessonsel' + i).select2().trigger('change');
                    }, timeoutvalue);
                    $('#duration' + i).val(optvalue[2]);
                    $('#prebrief' + i).val(optvalue[3]);
                    $('#postbrief' + i).val(optvalue[4]);
                    $('#mission' + i).val(optvalue[5]);    
                    //alert(optvalue[6]);
                    //var pcslarray = optvalue[6].split(',');                   
                    //alert(pcslarray[0]);  //Pilot 
                    //alert(pcslarray[1]);  //CSO
                    //alert(pcslarray[2]);  //SMA
                    //alert(pcslarray[3]);  //LM
                    if (optvalue[6] == "True") {
                        $("#Pilot" + i).prop("checked", true);
                    }
                    else {
                        $("#Pilot" + i).prop("checked", false);
                    }
                    if (optvalue[8] == "True") {
                        $("#CSO" + i).prop("checked", true);            
                    }
                    else {
                        $("#CSO" + i).prop("checked", false);
                    }
                    if (optvalue[10] == "True") {
                        $("#SMA" + i).prop("checked", true);              
                    }
                    else {
                        $("#SMA" + i).prop("checked", false);
                    }
                    if (optvalue[12] == "True") {
                        $("#LM" + i).prop("checked", true);
                    }
                    else {
                        $("#LM" + i).prop("checked", false);
                    }     
                    
                    if (optvalue[7] == "None") {
                        /*
                        setTimeout(function () {
                            $('#pilotprereq' + i).select2();
                            $('#pilotprereq' + i).select2().val("None");
                            $('#pilotprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {                            
                        //create unique array
                        myData[i] = JSON.parse("[" + optvalue[7] + "]");
                        setTimeout(function () {
                            $('#pilotprereq' + i).select2();
                            $('#pilotprereq' + i).select2().val(myData[i]);
                            $('#pilotprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }   

                    if (optvalue[9] == "None") {
                        /*
                        setTimeout(function () {
                            $('#csoprereq' + i).select2();
                            $('#csoprereq' + i).select2().val("None");
                            $('#csoprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData2[i] = JSON.parse("[" + optvalue[9] + "]");
                        setTimeout(function () {
                            $('#csoprereq' + i).select2();
                            $('#csoprereq' + i).select2().val(myData2[i]);
                            $('#csoprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }


                    if (optvalue[11] == "None") {
                        /*
                        setTimeout(function () {
                            $('#smaprereq' + i).select2();
                            $('#smaprereq' + i).select2().val("None");
                            $('#smaprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData3[i] = JSON.parse("[" + optvalue[11] + "]");
                        setTimeout(function () {
                            $('#smaprereq' + i).select2();
                            $('#smaprereq' + i).select2().val(myData3[i]);
                            $('#smaprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }

                    if (optvalue[13] == "None") {
                        /*
                        setTimeout(function () {
                            $('#lmprereq' + i).select2();
                            $('#lmprereq' + i).select2().val("None");
                            $('#lmprereq' + i).select2().trigger('change');
                        }, 1000);
                        */
                    }
                    else {
                        //create unique array
                        myData4[i] = JSON.parse("[" + optvalue[13] + "]");
                        setTimeout(function () {
                            $('#lmprereq' + i).select2();
                            $('#lmprereq' + i).select2().val(myData4[i]);
                            $('#lmprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }
                }
                document.getElementById("yestemplate").style.display = "inline";
                $('#bt2').val("Overwrite Template");
            }
        });
        
        if (dropdownid == 0) {
            document.getElementById("SOITable").style.display = "none";
        }
        else {
            document.getElementById("SOITable").style.display = "inline";
        }        
        
    }

    function validateSMA(rowCnt) {
        if ($("#SMA" + rowCnt).is(':checked')) {
            $("#CSO" + rowCnt).prop("checked", false);
        }     
    }
    function validateCSO(rowCnt){
        if ($("#CSO" + rowCnt).is(':checked')) {
            $("#SMA" + rowCnt).prop("checked", false);
        }   
    }

    function Pilotprereq(rowCnt) {
        var data = $('#pilotprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#pilottd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#pilotprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#pilottd" + rowCnt)[0].style.backgroundColor = 'red';
                    //$("#select2-pilotprereq" + rowCnt + "-container")[0].style.color = 'red';
                }
            }  
        }

        if (data != "") {
            $("#Pilot" + rowCnt).prop("checked", true);
        }
        else {
            $("#Pilot" + rowCnt).prop("checked", false);
        }
    }

    function CSOprereq(rowCnt) {
        var data = $('#csoprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#csotd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#csoprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#csotd" + rowCnt)[0].style.backgroundColor = 'red';
                }       
            }
        }

        if (data != "") {
            if ($("#SMA" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#CSO" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#CSO" + rowCnt).prop("checked", false);
        }
    }

    function SMAprereq(rowCnt) {
        var data = $('#smaprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#smatd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#smaprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#smatd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            if ($("#CSO" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#SMA" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#SMA" + rowCnt).prop("checked", false);
        }
    }

    function LMprereq(rowCnt) {
        var data = $('#lmprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#lmtd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#lmprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#lmtd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            $("#LM" + rowCnt).prop("checked", true);
        }
        else {
            $("#LM" + rowCnt).prop("checked", false);
        }
    }

    function handleChange(input) {
        if (input.value < 1) input.value = 1;
        if (input.value > 50) input.value = 50;
    }

    function insertrows() {  
        let empTab = document.getElementById('empTable');
        let rowCnt = empTab.rows.length;    // get the number of rows.
        let rowstoadd = document.getElementById('rowstoadd').value;
        let rowCntint = parseInt(rowCnt);
        let rowstoaddint = parseInt(rowstoadd);   
        let totalrows = rowCntint + rowstoaddint;        
        if (rowCntint != 0) {
            for (let i = 0; i < rowstoaddint; i++) {
                addRow();
            }
        }
        else {
            for (let i = 0; i < totalrows; i++) {
                addRow();
            }
        }    
    }

    function checkmediatype(rowCnt) {       
        //alert(rowCnt);
        var lessid = $('#lessonsel' + rowCnt).val();
        var duration = $('#duration' + rowCnt).val();
        var prebrief = $('#prebrief' + rowCnt).val();
        var postbrief = $('#postbrief' + rowCnt).val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");   
                    $("#duration" + rowCnt)[0].type = 'text';
                    $("#duration" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#duration" + rowCnt).val('R');
                    $("#duration" + rowCnt).prop("readonly", true);

                    $("#prebrief" + rowCnt)[0].type = 'text';
                    $("#prebrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#prebrief" + rowCnt).val('R');
                    $("#prebrief" + rowCnt).prop("readonly", true);

                    $("#postbrief" + rowCnt)[0].type = 'text';
                    $("#postbrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#postbrief" + rowCnt).val('R');
                    $("#postbrief" + rowCnt).prop("readonly", true);
                }
                else {
                    if (duration == 0 || duration == "R") {
                        $("#duration" + rowCnt)[0].type = 'number';
                        $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#duration" + rowCnt).val('0');
                        $("#duration" + rowCnt).prop("readonly", false);
                    }
                    if (prebrief == 0 || prebrief == "R") {
                        $("#prebrief" + rowCnt)[0].type = 'number';
                        $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#prebrief" + rowCnt).val('0');
                        $("#prebrief" + rowCnt).prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#postbrief" + rowCnt)[0].type = 'number';
                        $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#postbrief" + rowCnt).val('0');
                        $("#postbrief" + rowCnt).prop("readonly", false);
                    }
                }
            });
        }
        else {
            if (duration == 0 || duration == "R") {
                $("#duration" + rowCnt)[0].type = 'number';
                $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                $("#duration" + rowCnt).val('0');
                $("#duration" + rowCnt).prop("readonly", false);
            }  
            if (prebrief == 0 || prebrief == "R") {
                $("#prebrief" + rowCnt)[0].type = 'number';
                $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#prebrief" + rowCnt).val('0');
                $("#prebrief" + rowCnt).prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#postbrief" + rowCnt)[0].type = 'number';
                $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#postbrief" + rowCnt).val('0');
                $("#postbrief" + rowCnt).prop("readonly", false);
            }
        }
    }
</script>


<style>
.table-dragable > tbody .grabable { cursor: grab; user-select: none }
.table-dragable > tbody > tr.grabbed {
  box-shadow: 0 0 10px 0 rgba(0,0,0,0.5);
}
.table-dragable > tbody > tr.grabbed:active * {
  cursor: grabbing !important;
}

    table { 
        width: 98%;
        margin: auto;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
        background-color: white;
 -webkit-user-select: auto; /* Safari */
 -ms-user-select: none; /* IE 10+ and Edge */
 user-select: auto; /* Standard syntax */
    }
    table, th, td { 
        border: solid 1px #DDD;
        border-collapse: collapse; 
        padding: 2px 3px; 
        text-align: center;   
    }

.buttonstyle {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.buttonstyle:focus,
.buttonstyle:hover {
    background-color: #005EB8;
    color: white;
}

.removebutton {
    height: 30px;
    line-height: 3px;
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.removebutton:focus,
.removebutton:hover {
    background-color: #005EB8;
    color: white;
}
input{
    color: black;
}
.lessonselect{
    width: 400px;
}
.pilotprereqsel{
    width: 400px;
}
.csoprereqsel{
    width: 400px;
}
.smaprereqsel{
    width: 400px;
}
.lmprereqsel{
    width: 400px;
}

.dayinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 50px;
}
.durationinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.prebriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.postbriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.missioninput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.checkboxlabels{
    width: 100px;  
}
.column0{
    width: 156.73px;
    min-width: 132.78px;
}
.column1{
    width: 67.28px;
    min-width: 57px;
}
.column2{
    width: 480.45px;
    min-width: 407px;
}
.column3{
    width: 90.89px;
    min-width: 77px;
}
.column4{
    width: 90.89px;
    min-width: 77px;
}
.column5{
    width: 90.89px;
    min-width: 77px;
}
.column6{
    width: 90.89px;
    min-width: 77px;
}
.column7{
    width: 90.89px;
    min-width: 77px;
}
.column8{
    width: 480.45px;
    min-width: 407px;
}
.column9{
    width: 90.89px;
    min-width: 77px;
}
.column10{
    width: 480.45px;
    min-width: 407px;
}
.column11{
    width: 90.89px;
    min-width: 77px;
}
.column12{
    width: 480.45px;
    min-width: 407px;
}
.column13{
    width: 90.89px;
    min-width: 77px;
}
.column14{
    width: 480.58px;
    min-width: 407px;
}
.cbclass{
    width: 25px;
    height: 25px;
}

.editlink{
    font-size: small;
    text-decoration: none;
    line-height: 30px;
}
.editlink:hover{
    text-decoration: underline;
}
#multirowsdiv{

    width: 260px;
    margin-left: 30px;
    margin-top: 10px;
    padding-left: 10px;
    padding-bottom: 10px;
    padding-right: 5px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>New SOI Build</h1></div>
<hr />
<br />
<div style="text-align: center; min-width: 520px;">
    <select id="selSOI" style="width: 450px;" onchange="loadsoitable()">
        
    </select>
    <a class='editlink' href='../CAT/EditSOI.aspx'>(edit list)</a>
</div>
    <div id="SOITable" style="display: none;">

    <div id="multirowsdiv" style="display: none;">
        Add <input type="number" min="1" value="1" max="99" id="rowstoadd" class="dayinput" onchange="handleChange(this);" style="width: 60px;" /> Row(s)<input type="button" style="margin-top: 10px;" class="buttonstyle" id="insertrows" value="Go" onclick="insertrows()" /> 
    </div>
    
        
        <span id="notemplate" style="display: none; float: right; border: 1px solid red; color:red; padding:3px; margin-right: 100px; margin-top: 30px; margin-bottom: 20px;">No Template Saved</span>    
        <span id="yestemplate" style="display: none; float: right; border: 1px solid green; color:green; padding:3px; margin-right: 100px; margin-top: 30px; margin-bottom: 20px;">Saved Template Loaded</span> 
  
    <table style="width: 98%; min-width: 1614.78px; background-color: #005EB8; color: white;">
    <thead>
    <tr>
    <th class="column0"></th>
    <th class="column1">Day</th>
    <th class="column2">Lesson</th>
    <th class="column3">Duration</th>
    <th class="column4">Pre Brief</th>
    <th class="column5">Post Brief</th>
    <th class="column6"># of Missions</th>
    <th class="column7">Pilot</th>
    <th class="column8">Pilot Prereqs</th>
    <th class="column9">CSO</th>
    <th class="column10">CSO Prereqs</th>
    <th class="column11">SMA</th>
    <th class="column12">SMA Prereqs</th>
    <th class="column13">LM</th>
    <th class="column14">LM Prereqs</th>
    </tr>
    </thead>
    </table>
    <div id="cont"></div>   <!--the container to add the table.-->
    <br />
    <div style="min-width: 500px;">
    <input type="button" style="margin-top: 10px;" class="buttonstyle" id="addRow" value="Add New Row" onclick="addRow()" />  
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt" value="Save Build" onclick="submit()" />
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt2" value="Save New Template" onclick="submit2()" />
    </div>
    <p id='output'></p>
    </div>

<br /><br /><br /><br /><br /><br />

<form name="savedata" id="savedata" method="post" enctype="multipart/form-data" action="../SOITable/savetabledata.aspx">
    <input style="width: 2000px;" type="hidden" id="tabledata" name="tabledata" />
    <input type="hidden" id="soiid" name="soiid" />
</form>

<form name ="savetemplate" id="savetemplate" method="post" enctype="multipart/form-data" action="../SOITable/savetemplate.aspx">
    <input type="hidden" id="templatetabledata" name="templatetabledata" />
    <input type="hidden" id="templatesoiid" name="templatesoiid" />
</form>


<script>

</script>


<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var selid;

    $(document).ready(function () {
        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Archived SOI Builds"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();        
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        selid = rowdata[4];       
    }

    function unarchivedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to unarchive this SOI build?") == true) {
                window.location.href = "../SOITable/unarchivesoi.aspx?buildid=" + selid;
            } else {
                return;
            }            
        }
    }

    function gotoreports() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            window.location.href = "../SOITable/SOIbuildreports.aspx?buildid=" + selid + "&reportid=0";
        }
    }
</script>
<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Archived SOI Builds</h1></div>
<hr />
<div style="margin: 35px;">
<button class="button" onclick="unarchivedata()">Unarchive Row</button>
<button class="button" onclick="gotoreports()">Reports</button>
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>Build ID</th>
                <th>SOI Title</th>     
                <th>Created By</th>
                <th>Creation Date</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            

<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
   
<script>
    var selid;

    $(document).ready(function () {
        $('#example').dataTable({
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": false,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Active SOI Builds"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;               
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');   
                var data = table.row(this).data();        
                savedata(data);
            }          
        });       
    }); 

    function savedata(rowdata) {
        selid = rowdata[4];       
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            window.location.href = "../SOITable/editsoitable.aspx?buildid=" + selid;
        }
    }

    function archivedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            if (confirm("Are you sure that you want to archive this SOI build?") == true) {
                window.location.href = "../SOITable/archivesoi.aspx?buildid=" + selid;
            } else {
                return;
            }            
        }
    }

    function gotoreports() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            window.location.href = "../SOITable/SOIbuildreports.aspx?buildid=" + selid + "&reportid=0";
        }
    }
</script>
<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Active SOI Builds</h1></div>
<hr />
<div style="margin: 35px;">
<button class="button" onclick="editdata()">Edit/View Row</button>
<button class="button" onclick="archivedata()">Archive Row</button>
<button class="button" onclick="gotoreports()">Reports</button>
<br /><br />
<table id="example" class="display" style="width:100%; border: none">
        <thead style="background-color: #005EB8; color: white">
            <tr>                
                <th>Build ID</th>
                <th>SOI Title</th>     
                <th>Created By</th>
                <th>Creation Date</th>
                <th style="display:none;">ID</th>
            </tr>
        </thead>
        <tbody>
            
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 

<script>
    $(document).ready(function () {
        $("#reportlist").select2();  
        var reportid = getUrlVars()["reportid"];
        if (reportid != "0") {                
            document.getElementById("reportlist").value = reportid;
            document.getElementById("reports_data").style.visibility = "visible"; 
            $("#reportlist").select2();
        }     
    });

    function loadreport() {        
        var reportid = document.getElementById('reportlist').value;
        var buildid = getUrlVars()["buildid"]; 
        //alert(dropdownid);     
        window.location.href = "../SOITable/SOIbuildreports.aspx?buildid=" + buildid + "&reportid=" + reportid;
    }

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function backtoactivebuilds() {
        window.location.href = "../SOITable/activesoibuilds.aspx";
    }

    function exporttopdf() {
        var reportid = getUrlVars()["reportid"];
        var buildid = getUrlVars()["buildid"];
        if (reportid == 1) {
            window.open("../SOITable/summaryreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");
        }
        else if (reportid == 2) {
            window.open("../SOITable/flowreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");   
        }
        else if (reportid == 3) {
            window.open("../SOITable/acadreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");
        }
        else if (reportid == 4) {
            window.open("../SOITable/atdreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");    
        }
        else if (reportid == 5) {
            window.open("../SOITable/flyreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");
        }
        else if (reportid == 6) {
            window.open("../SOITable/sptreport.aspx?buildid=" + buildid + "&reportid=" + reportid, "_blank");
        }
    }
</script>
<style>
.select2-search__field {
    color: black;
}
.reporttable{
    border: 1px solid;
    border-collapse:collapse;
    font-size: 15px;
    font-family: 'Times New Roman', Times, serif;
}
.reporttable th{
    background-color: #005EB8;
    color: white;
    padding: 5px;    
    text-align: center;
    font-style: italic;
    font-weight: normal;
    /*
    //For vertical table headers
    writing-mode: vertical-lr;
    transform: rotate(180deg);
    */
}
.reporttable tbody{
    background-color: white; 
    text-align: center;
}
.reporttable tbody td{
    padding: 2px;
    border: 1px solid;
}
.reportrow1{
    border-bottom: 1px solid white;
}
.reportrow2{
    height: 40px;
}
#adobediv{
    display: flex;
    justify-content: center;
}
.total_column{
    border-left: 4px solid !important;
    border-style: double !important;
}
.column{
    height: 100%;
    padding: 50px;
}
#totalrow{
    border-top: 4px solid !important;
    border-top-style: double !important;
    background-color: lightblue;
}
/*
.reporttable td{
    border: 1px solid black;
    border-collapse: collapse;
}
*/
#flowreporttable{
    border: 1px solid black !important;
    border-collapse: collapse;
    border-style: none;
    border-spacing: 0px;
    padding: 0;
    margin-left:auto; 
    margin-right:auto;
    
}
#flowreporttable th{
    background-color: #005EB8;
    color: white;
    padding: 5px;    
    text-align: center;
    font-style: italic;
    font-weight: bold;
    border: none;
}
#verticalcols th{

    /*
    writing-mode: vertical-lr;
    transform: rotate(180deg);
    */

    border: none;
}
#flowrow1{
    border-bottom: 2px solid white;
}
.dayrow {
    background-color: lightblue;
    font-weight: bold;
    border: 1px solid;
}
.dayrow td{
    padding: 5px !important;
}
.datarow td{
    padding: 7px !important;
    background-color: white;
    border: 1px solid;
}
.totalsrow{
    background-color: lightblue;
    font-weight: bold;
    border: 1px solid;
}
.totalsrow td{
    padding: 5px !important;
}

.totalcolstyle{   
    text-align: right;
    border-left: 3px solid;
}

.acadtableheader{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: #005EB8;
    color: white;
    height: 50px;
    border-top: 1px solid black;
    border-left: 1px solid black;
    border-right: 1px solid black;
    border-spacing: 0px;
    padding: 0;
}
.acadtableheader2{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
    color: black;
    height: 20px;
    border: 1px solid;
    border-spacing: 0px;
    padding: 0;
    font-style: italic;
}
.col1{
    width: 618.83px;
}
.col2{
    width: 147.53px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col3{
    width: 233.64px;
}

.acadtable{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
}
.acadtable {   
    border-style: none;
    border-spacing: 0px;
    padding: 0;
    margin: auto;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
}
.acadtable th{
    border-bottom: 1px solid;
    border-right: 1px solid;
    font-style: italic;
    width: 84px;
    padding: 5px;
}
.acadtable tbody tr{
    background-color: white;
    height: 30px;
    text-align: center;
}
.acadtable tbody td{
    border-style: none;
    border: 1px solid !important;
    padding: 5px;    
}


.ATDtableheader{
    width:1200px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: #005EB8;
    color: white;
    height: 50px;
    border-top: 1px solid black;
    border-left: 1px solid black;
    border-right: 1px solid black;
    border-spacing: 0px;
    padding: 0;
}
.ATDtableheader2{
    width:1200px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
    color: black;
    height: 20px;
    border-left: 1px solid;
    border-right: 1px solid;
    border-top: 1px solid;
    border-spacing: 0px;
    padding: 0;
    font-style: italic;
}
.ATDtableheader3{
    width:1200px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
    color: black;
    height: 20px;
    border: 1px solid;
    border-spacing: 0px;
    padding: 0;
    font-style: italic;
}
.col4{
    width: 593.47px;
}
.col5{
    width: 241.75px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col6{
    width: 362.78px;
}
.col7{
    width: 594.67px;
}
.col8{
    width: 121.06px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col9{
    width: 121.06px;
    border-right: 1px solid;
    padding: 5px;
}
.col10{
    width: 121.06px;
    border-right: 1px solid;
    padding: 5px;
}
.col11{
    width: 121.06px;
    border-right: 1px solid;
    padding: 5px;
}
.col12{
    width: 121.06px;
    padding: 5px;
}
.ATDtable{
    width:1200px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
}
.ATDtable {   
    border-style: none;
    border-spacing: 0px;
    padding: 0;
    margin: auto;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
}
.ATDtable th{
    border-bottom: 1px solid;
    border-right: 1px solid;
    font-style: italic;
    width: 84px;
    padding: 5px;
}
.ATDtable tbody tr{
    background-color: white;
    height: 30px;
    text-align: center;
}
.ATDtable tbody td{
    border-style: none;
    border: 1px solid !important;
    padding: 5px;
}

/* Fly Table colum adjustments */
.col14{
    width: 593.63px;
}
.col15{
    width: 241.7px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col16{
    width: 362px;
    padding: 5px;
}
.col17{
    width: 594.67px;
}
.col18{
    width: 121px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col19{
    width: 121px;
    border-right: 1px solid;
    padding: 5px;
}
.col20{
    width: 121px;
    border-right: 1px solid;
    padding: 5px;
}
.col21{
    width: 121px;
    border-right: 1px solid;
    padding: 5px;
}
.col22{
    width: 121px;
    padding: 5px;
}

.spttableheader{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: #005EB8;
    color: white;
    height: 50px;
    border-top: 1px solid black;
    border-left: 1px solid black;
    border-right: 1px solid black;
    border-spacing: 0px;
    padding: 0;
}
.spttableheader2{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
    color: black;
    height: 20px;
    border: 1px solid;
    border-spacing: 0px;
    padding: 0;
    font-style: italic;
}
.col23{
    width: 650.85px;
}
.col24{
    width: 106.29px;
    border-left: 1px solid;
    border-right: 1px solid;
    padding: 5px;
}
.col25{
    width: 106.29px;
}
.col26{
    width: 136.56px;
    border-left: 1px solid;
    padding: 5px;
}

.spttable{
    width:1000px; 
    margin-left:auto; 
    margin-right:auto;
    background-color: lightblue;
}
.spttable {   
    border-style: none;
    border-spacing: 0px;
    padding: 0;
    margin: auto;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
}
.spttable th{
    border-bottom: 1px solid;
    border-right: 1px solid;
    font-style: italic;
    width: 84px;
    padding: 5px;
}
.spttable tbody tr{
    background-color: white;
    height: 30px;
    text-align: center;
}
.spttable tbody td{
    border-style: none;
    border: 1px solid !important;
    padding: 5px;    
}

</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>SOI Build Reports<br /><span style="color: #005EB8"></span></h1></div>
<hr />
<br />
<div style="text-align: center; min-width: 550px;">   
    <select id="reportlist" style="width: 450px;" onchange="loadreport()">
       <option value="0">Select Report</option>
       <option value="1">Summary Report</option>
       <option value="2">Flow Report</option>
       <option value="3">Acad Report</option>
       <option value="4">ATD Report</option>
       <option value="5">Fly Report</option>
       <option value="6">Spt Report</option>
    </select>   
<br /><br />    
</div>
<hr />
<button style="margin-left: 20px; margin-top: 4px;" class="button" onclick="backtoactivebuilds()">&#11164; Back to Active SOI Builds</button>
<br /><br />
<div style="visibility: hidden;" id="reports_data"> 
    

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="../scripts/dataTables.rowReorder.min.js"></script>

<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<link rel="stylesheet" href="../styles/rowReorder.dataTables.min.css" /> 

<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />

<script>
    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    var ROW;
    var DAYSTRING;
    var LESSON;
    var DURATION;
    var PREBRIEF;
    var POSTBRIEF;
    var NUM_MISSIONS;
    var PILOT;
    var PILOT_PREREQS;
    var CSO;
    var CSO_PREREQS;
    var SMA;
    var SMA_PREREQS;
    var LM;
    var LM_PRREQS;
    var LESSID;
    var PILOT_PREREQ_LIST;
    var CSO_PREREQ_LIST;
    var SMA_PREREQ_LIST;
    var LM_PREREQ_LIST;
    var REVIEW;
    var DAY;
    var selid;

    $(document).ready(function () {
        $("#LESSID").select2();
        $("#PILOTPREREQS").select2({
            placeholder: "Select Pilot Prereqs"
        });   
        $("#CSOPREREQS").select2({
            placeholder: "Select CSO Prereqs"
        }); 
        $("#SMAPREREQS").select2({
            placeholder: "Select SMA Prereqs"
        }); 
        $("#LMPREREQS").select2({
            placeholder: "Select LM Prereqs"
        }); 

        $("#EDITLESSID").select2();
        $("#EDITPILOTPREREQS").select2({
            placeholder: "Select Pilot Prereqs"
        });
        $("#EDITCSOPREREQS").select2({
            placeholder: "Select CSO Prereqs"
        });
        $("#EDITSMAPREREQS").select2({
            placeholder: "Select SMA Prereqs"
        });
        $("#EDITLMPREREQS").select2({
            placeholder: "Select LM Prereqs"
        }); 

        var buildid = getUrlVars()["buildid"];       

        $('#buildid').val(buildid);
        $('#editbuildid').val(buildid);

        $.ajax({
            url: 'getbuilds.asmx/GetBuilds?buildid=' + buildid,
            method: 'post',
            dataType: 'json',
            success: function (data) {
                $('#example').dataTable({
                    "bPaginate": false,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bInfo": true,
                    "bAutoWidth": true,      
                    "scrollY": "400px",
                    "sScrollX": "100%",
                    "sScrollXInner": "100%",
                    "scrollCollapse": true,
                    "language": {
                        "emptyTable": "No Build"
                    },
                    data: data,
                    columns: [
                        { 'data': 'ROW' },
                        { 'data': 'DAYSTRING' },
                        { 'data': 'LESSON' },
                        { 'data': 'DURATION' },
                        { 'data': 'PREBRIEF' },
                        { 'data': 'POSTBRIEF' },
                        { 'data': 'NUM_MISSIONS' },
                        { 'data': 'PILOT' },
                        { 'data': 'PILOT_PREREQS' },
                        { 'data': 'CSO' },
                        { 'data': 'CSO_PREREQS' },
                        { 'data': 'SMA' },
                        { 'data': 'SMA_PREREQS' },
                        { 'data': 'LM' },
                        { 'data': 'LM_PREREQS' },  
                        { 'data': 'LESSID', "visible": false },  
                        { 'data': 'PILOT_PREREQ_LIST', "visible": false },  
                        { 'data': 'CSO_PREREQ_LIST', "visible": false }, 
                        { 'data': 'SMA_PREREQ_LIST', "visible": false }, 
                        { 'data': 'LM_PREREQ_LIST', "visible": false }, 
                        { 'data': 'REVIEW', "visible": false },
                        { 'data': 'DAY', "visible": false },
                        { 'data': 'ID', "visible": false }
                    ],
                    columnDefs: [
                        { width: 20, targets: 0 },
                        { width: 20, targets: 1 },
                        { width: 250, targets: 2 },
                        { width: 15, targets: 3 },
                        { width: 15, targets: 4 },
                        { width: 40, targets: 5 },
                        { width: 15, targets: 6 },
                        { width: 20, targets: 7 },
                        { width: 250, targets: 8 },
                        { width: 20, targets: 9 },
                        { width: 250, targets: 10 },
                        { width: 20, targets: 11 },
                        { width: 250, targets: 12 },
                        { width: 20, targets: 13 },
                        { width: 250, targets: 14 },
                        { width: 0, targets: 15 }, 
                        { width: 0, targets: 16 }, 
                        { width: 0, targets: 17 }, 
                        { width: 0, targets: 18 }, 
                        { width: 0, targets: 19 }, 
                        { width: 0, targets: 20 }, 
                        { width: 0, targets: 21 },
                        { width: 0, targets: 22 }      
                    ],
                    fixedColumns: true,
                    rowReorder: {
                        dataSrc: 'ROW',
                        selector: 'tr td:first-of-type'
                    }
                });
                var table = $('#example').DataTable();

                const rowindex = [];
                const newrows = [];

                let rowindextext = "";   
                let newrowstext = "";              
                
                table.on('row-reorder', function (e, diff, edit) {                   
                    document.getElementById("savebutton").style.display = "inline";
                    var result = "";
                    for (var i = 0, ien = diff.length; i < ien; i++) {                           
                        result += ' Row ' + diff[i].newData + ' (was ' + diff[i].oldData + ')';
                        rowindex.push(diff[i].oldData);
                        newrows.push(diff[i].newData);
                    }
                    //alert(result);
                    rowindextext = rowindex.toString();
                    newrowstext = newrows.toString();

                    $("#rowindex").val(rowindextext);
                    $("#newrow").val(newrowstext);
                                        
                    table.rowReorder.disable();
                    
                    let firstCol = document.querySelectorAll('tr td:first-of-type');
                    for (let i = 0; i < firstCol.length; i++) {
                        firstCol[i].style.cursor = 'auto';
                    }                
                });            

                $('#example tbody').on('click', 'tr', function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        selid = null;
                    }
                    else {
                        table.$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        var data = table.row(this).data();
                        //const myJSON = JSON.stringify(data);
                        //alert(myJSON);
                        savedata(data);
                    }
                });
            }
        });
    });

    function savedata(rowdata) {
        ROW = rowdata.ROW;
        DAYSTRING = rowdata.DAYSTRING;
        LESSON = rowdata.LESSON;
        DURATION = rowdata.DURATION;
        PREBRIEF = rowdata.PREBRIEF;
        POSTBRIEF = rowdata.POSTBRIEF;
        NUM_MISSIONS = rowdata.NUM_MISSIONS;
        PILOT = rowdata.PILOT;
        PILOT_PREREQS = rowdata.PILOT_PREREQS;
        CSO = rowdata.CSO;
        CSO_PREREQS = rowdata.CSO_PREREQS;
        SMA = rowdata.SMA;
        SMA_PREREQS = rowdata.SMA_PREREQS;
        LM = rowdata.LM;
        LM_PREREQS = rowdata.LM_PREREQS;
        LESSID = rowdata.LESSID;
        PILOT_PREREQ_LIST = rowdata.PILOT_PREREQ_LIST;
        CSO_PREREQ_LIST = rowdata.CSO_PREREQ_LIST;
        SMA_PREREQ_LIST = rowdata.SMA_PREREQ_LIST;
        LM_PREREQ_LIST = rowdata.LM_PREREQ_LIST;
        REVIEW = rowdata.REVIEW;
        DAY = rowdata.DAY;
        selid = rowdata.ID;
    }

    function newlesson() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            setTimeout(function () {
                $('#EDITPILOTPREREQS').select2();
                $('#EDITPILOTPREREQS').select2().val('');
                $('#EDITPILOTPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITCSOPREREQS').select2();
                $('#EDITCSOPREREQS').select2().val('');
                $('#EDITCSOPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITSMAPREREQS').select2();
                $('#EDITSMAPREREQS').select2().val('');
                $('#EDITSMAPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITLMPREREQS').select2();
                $('#EDITLMPREREQS').select2().val('');
                $('#EDITLMPREREQS').select2().trigger('change');
            }, 0);

            setTimeout(function () {
                $("#EDITPILOTPREREQS").select2({
                    placeholder: "Select Pilot Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITCSOPREREQS").select2({
                    placeholder: "Select CSO Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITSMAPREREQS").select2({
                    placeholder: "Select SMA Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITLMPREREQS").select2({
                    placeholder: "Select LM Prereqs"
                });
            }, 0);

            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";  
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val('');
                    $('#EDITPILOTPREREQS').select2().trigger('change');                    
                }, 0);   
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val('');
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val('');
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val('');
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0); 
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0); 
                }
            };

            $('#editid').val(selid);
            $('#EDITDAY').val(DAY);          

            setTimeout(function () {
                $('#EDITLESSID').select2();
                $('#EDITLESSID').select2().val(LESSID);
                $('#EDITLESSID').select2().trigger('change');
            }, 0);

            $('#EDITDURATION').val(DURATION);
            $('#EDITPREBRIEF').val(PREBRIEF);
            $('#EDITPOSTBRIEF').val(POSTBRIEF);
            $('#EDITMISSIONS').val(NUM_MISSIONS);
                      
            if (PILOT == "True") {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", true);
                }, 0);               
            }
            else {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", false);
                }, 0);                 
            }
            if (CSO == "True") {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", true);
                }, 0);                 
            }
            else {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", false);
                }, 0);                 
            }
            if (SMA == "True") {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", false);
                }, 0);                 
            }
            if (LM == "True") {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", false);
                }, 0);                  
            }
            //alert(PILOT_PREREQ_LIST);      
            if (PILOT_PREREQ_LIST != "None") {
                const myData = JSON.parse("[" + PILOT_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val(myData);
                    $('#EDITPILOTPREREQS').select2().trigger('change');
                }, 0);
            }
            if (CSO_PREREQ_LIST != "None") {
                const myData2 = JSON.parse("[" + CSO_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val(myData2);
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
            }
            if (SMA_PREREQ_LIST != "None") {
                const myData3 = JSON.parse("[" + SMA_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val(myData3);
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
            }
            if (LM_PREREQ_LIST != "None") {
                const myData4 = JSON.parse("[" + LM_PREREQ_LIST + "]");       
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val(myData4);
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }   
            
            if (REVIEW == 1) {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", true);
                }, 0);                
            }
            else {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", false);
                }, 0);                   
            }
        }
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var buildid = getUrlVars()["buildid"];
            if (confirm("Are you sure that you want to delete this row?") == true) {
                window.location.href = "../SOITable/deletelesson.aspx?type=build&buildid=" + buildid + "&selid=" + selid;
            } else {
                return;
            }
        }
    }
    function canceldrag() {
        var buildid = getUrlVars()["buildid"];
        window.location.href = "../SOITable/editsoitable.aspx?buildid=" + buildid;
    }

    function backtoactivebuilds() {
        window.location.href = "../SOITable/activesoibuilds.aspx";
    }

    function Pilotprereq() {    
        var data = $('#PILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#PILOT").prop("checked", true);
        }
        else {
            $("#PILOT").prop("checked", false);
        }
    }

    function CSOprereq() {
        var data = $('#CSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#CSO").prop("checked", true);
        }
        else {
            $("#CSO").prop("checked", false);
        }
        validateCSO();
    }

    function SMAprereq() {
        var data = $('#SMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#SMA").prop("checked", true);
        }
        else {
            $("#SMA").prop("checked", false);
        }
        validateSMA();
    }

    function LMprereq() {
        var data = $('#LMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#LM").prop("checked", true);
        }
        else {
            $("#LM").prop("checked", false);
        }
    }

    function Pilotprereq2() {
        var data = $('#EDITPILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITPILOT").prop("checked", true);
        }
        else {
            $("#EDITPILOT").prop("checked", false);
        }
    }

    function CSOprereq2() {
        var data = $('#EDITCSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITCSO").prop("checked", true);
        }
        else {
            $("#EDITCSO").prop("checked", false);
        }
        validateCSO2();
    }

    function SMAprereq2() {
        var data = $('#EDITSMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITSMA").prop("checked", true);
        }
        else {
            $("#EDITSMA").prop("checked", false);
        }
        validateSMA2();
    }

    function LMprereq2() {
        var data = $('#EDITLMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITLM").prop("checked", true);
        }
        else {
            $("#EDITLM").prop("checked", false);
        }
    }

    function validateSMA() {
        if ($("#SMA").is(':checked')) {
            $("#CSO").prop("checked", false);
        }
    }
    function validateCSO() {
        if ($("#CSO").is(':checked')) {
            $("#SMA").prop("checked", false);  
        }
    }

    function validateSMA2() {
        if ($("#EDITSMA").is(':checked')) {
            $("#EDITCSO").prop("checked", false);
        }
    }
    function validateCSO2() {
        if ($("#EDITCSO").is(':checked')) {
            $("#EDITSMA").prop("checked", false);
        }
    }

    function checkmediatype() {
        //alert(rowCnt);
        var lessid = $('#LESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#DURATION').val();
        var prebrief = $('#PREBRIEF').val();
        var postbrief = $('#POSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#reviewcheckbox")[0].style.display = 'flex';

                    if ($("#Review").is(':checked')) {
                        $("#DURATION")[0].type = 'text';
                        $("#DURATION")[0].style.backgroundColor = 'black';
                        $("#DURATION").val('R');
                        $("#DURATION").prop("readonly", true);
                        /*
                        $("#PREBRIEF")[0].type = 'text';
                        $("#PREBRIEF")[0].style.backgroundColor = 'black';
                        $("#PREBRIEF").val('R');
                        $("#PREBRIEF").prop("readonly", true);

                        $("#POSTBRIEF")[0].type = 'text';
                        $("#POSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#POSTBRIEF").val('R');
                        $("#POSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#DURATION")[0].type = 'number';
                            $("#DURATION")[0].style.backgroundColor = '#3b4148';
                            $("#DURATION").val('0');
                            $("#DURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#PREBRIEF")[0].type = 'number';
                            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#PREBRIEF").val('0');
                            $("#PREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#POSTBRIEF")[0].type = 'number';
                            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#POSTBRIEF").val('0');
                            $("#POSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#reviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#DURATION")[0].type = 'number';
                        $("#DURATION")[0].style.backgroundColor = '#3b4148';
                        $("#DURATION").val('0');
                        $("#DURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#PREBRIEF")[0].type = 'number';
                        $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#PREBRIEF").val('0');
                        $("#PREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#POSTBRIEF")[0].type = 'number';
                        $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#POSTBRIEF").val('0');
                        $("#POSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#reviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#DURATION")[0].type = 'number';
                $("#DURATION")[0].style.backgroundColor = '#3b4148';
                $("#DURATION").val('0');
                $("#DURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#PREBRIEF")[0].type = 'number';
                $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#PREBRIEF").val('0');
                $("#PREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#POSTBRIEF")[0].type = 'number';
                $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#POSTBRIEF").val('0');
                $("#POSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function checkmediatype2() {
        //alert(rowCnt);
        var lessid = $('#EDITLESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#EDITDURATION').val();
        var prebrief = $('#EDITPREBRIEF').val();
        var postbrief = $('#EDITPOSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#EDITreviewcheckbox")[0].style.display = 'flex';

                    if ($("#EDITReview").is(':checked')) {
                        $("#EDITDURATION")[0].type = 'text';
                        $("#EDITDURATION")[0].style.backgroundColor = 'black';
                        $("#EDITDURATION").val('R');
                        $("#EDITDURATION").prop("readonly", true);
                        /*
                        $("#EDITPREBRIEF")[0].type = 'text';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPREBRIEF").val('R');
                        $("#EDITPREBRIEF").prop("readonly", true);

                        $("#EDITPOSTBRIEF")[0].type = 'text';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPOSTBRIEF").val('R');
                        $("#EDITPOSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#EDITDURATION")[0].type = 'number';
                            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                            $("#EDITDURATION").val('0');
                            $("#EDITDURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#EDITPREBRIEF")[0].type = 'number';
                            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPREBRIEF").val('0');
                            $("#EDITPREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#EDITPOSTBRIEF")[0].type = 'number';
                            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPOSTBRIEF").val('0');
                            $("#EDITPOSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#EDITreviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#EDITDURATION")[0].type = 'number';
                        $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                        $("#EDITDURATION").val('0');
                        $("#EDITDURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#EDITPREBRIEF")[0].type = 'number';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPREBRIEF").val('0');
                        $("#EDITPREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#EDITPOSTBRIEF")[0].type = 'number';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPOSTBRIEF").val('0');
                        $("#EDITPOSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#EDITreviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#EDITDURATION")[0].type = 'number';
                $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                $("#EDITDURATION").val('0');
                $("#EDITDURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#EDITPREBRIEF")[0].type = 'number';
                $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPREBRIEF").val('0');
                $("#EDITPREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#EDITPOSTBRIEF")[0].type = 'number';
                $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPOSTBRIEF").val('0');
                $("#EDITPOSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function changevalues() {
        if ($("#Review").is(':checked')) {
            $("#DURATION")[0].type = 'text';
            $("#DURATION")[0].style.backgroundColor = 'black';
            $("#DURATION").val('R');
            $("#DURATION").prop("readonly", true);
            /*
            $("#PREBRIEF")[0].type = 'text';
            $("#PREBRIEF")[0].style.backgroundColor = 'black';
            $("#PREBRIEF").val('R');
            $("#PREBRIEF").prop("readonly", true);

            $("#POSTBRIEF")[0].type = 'text';
            $("#POSTBRIEF")[0].style.backgroundColor = 'black';
            $("#POSTBRIEF").val('R');
            $("#POSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#DURATION")[0].type = 'number';
            $("#DURATION")[0].style.backgroundColor = '#3b4148';
            $("#DURATION").val('0');
            $("#DURATION").prop("readonly", false);
            /*
            $("#PREBRIEF")[0].type = 'number';
            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#PREBRIEF").val('0');
            $("#PREBRIEF").prop("readonly", false);

            $("#POSTBRIEF")[0].type = 'number';
            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#POSTBRIEF").val('0');
            $("#POSTBRIEF").prop("readonly", false);
            */
        }
    }

    function changevalues2() {
        if ($("#EDITReview").is(':checked')) {
            $("#EDITDURATION")[0].type = 'text';
            $("#EDITDURATION")[0].style.backgroundColor = 'black';
            $("#EDITDURATION").val('R');
            $("#EDITDURATION").prop("readonly", true);
            /*
            $("#EDITPREBRIEF")[0].type = 'text';
            $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPREBRIEF").val('R');
            $("#EDITPREBRIEF").prop("readonly", true);

            $("#EDITPOSTBRIEF")[0].type = 'text';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPOSTBRIEF").val('R');
            $("#EDITPOSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#EDITDURATION")[0].type = 'number';
            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
            $("#EDITDURATION").val('0');
            $("#EDITDURATION").prop("readonly", false);
            /*
            $("#EDITPREBRIEF")[0].type = 'number';
            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPREBRIEF").val('0');
            $("#EDITPREBRIEF").prop("readonly", false);

            $("#EDITPOSTBRIEF")[0].type = 'number';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPOSTBRIEF").val('0');
            $("#EDITPOSTBRIEF").prop("readonly", false);
            */
        }
    }

    function savetemplate() {
        let text = "Are you sure that you want to proceed? This will overwrite if a template was already saved for this SOI.";
        if (confirm(text) == true) {
            var buildid = getUrlVars()["buildid"];
            window.location.href = "../SOITable/savebuildastemplate.aspx?buildid=" + buildid;
        } else {
            return;
        }
    }

    function checklesson(form) {
        var lessoncheck = form.LESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }

    function checklesson2(form) {
        var lessoncheck = form.EDITLESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }
</script>

<style>
table tr td:first-of-type {
  cursor: move;  
}
table tr td{
  text-align: center;
}

#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {  
  #myModal{
        width: 580px;
        min-width: 580px;
        font-size: 10px;
    }
  #myModal2{
        width: 580px;
        min-width: 580px;
        font-size: 10px;    
    }
}

.modal{
    width: 1700px;
}
#pilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#PILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#pilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#csocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#CSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#csocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#smacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#SMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#smacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#lmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#LM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#lmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#reviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#Review{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#reviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

#EDITpilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#EDITPILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITpilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITcsocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITCSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITcsocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITsmacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITSMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITsmacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITlmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#EDITLM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITlmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITreviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#EDITReview{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITreviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

.InfoTitles{
    margin-top: 13px;
    float: left;
    width: 200px;
    color: black;
    text-align: right;
}

.select2-search__field {
    color: black;
}

.buttonred {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkred;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttonred:focus,
.buttonred:hover {
    background-color: darkred;
    color: white
}

.buttongreen {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkgreen;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttongreen:focus,
.buttongreen:hover {
    background-color: darkgreen;
    color: white
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Edit SOI Build<br /><span style="color: #005EB8"></span></h1></div>
<hr />
<button style="margin-left: 20px; margin-top: 4px;" class="button" onclick="backtoactivebuilds()">&#11164; Back to Active SOI Builds</button>
<div id="SOITable" style="margin: 35px; min-width: 600px;">
<button class="button" onclick="newlesson()">Add Row</button>
<button class="button" onclick="editdata()">Edit Row</button>
<button class="button" onclick="deletedata()">Delete Row</button>
<button class="buttongreen" onclick="savetemplate()">Save Build as Template</button>
<br /><br />




<table id="example" class="display" style="width:100%; border: none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>    
                <th>Order</th>
                <th>Day</th>
                <th>Lesson</th>    
                <th>Duration</th>   
                <th>Pre Brief</th> 
                <th>Post Brief</th> 
                <th># of Missions</th> 
                <th>Pilot</th>
                <th>Pilot Prereqs</th> 
                <th>CSO</th> 
                <th>CSO Prereqs</th> 
                <th>SMA</th>             
                <th>SMA Prereqs</th>        
                <th>LM</th>
                <th>LM Prereqs</th> 
                <th>LESSID</th>
                <th>Pilot Prereqs List</th>
                <th>CSO Prereqs List</th>
                <th>SMA Prereqs List</th>
                <th>LM Prereqs List</th>
                <th>Review</th>
                <th>Day</th>
                <th>ID</th> 
            </tr>
        </thead>
        <tbody>                    
        </tbody>
    </table>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/newlesson.aspx?type=build" method="post" enctype="multipart/form-data" onsubmit="return checklesson(this)">
       <input type="hidden" name="buildid" id="buildid" /> 
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="DAY" id="DAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="LESSID" name="LESSID" style="width: 100%;" onchange="checkmediatype();">
                   
            </select>
       </div> 
    
       <div class="form__field" id="reviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='Review' name='Review' onchange='changevalues();'><label for='Review'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="DURATION" id="DURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="PREBRIEF" id="PREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="POSTBRIEF" id="POSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="MISSIONS" id="MISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="pilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='PILOT' name='PILOT'><label for='PILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="PILOTPREREQS" name="PILOTPREREQS" style="width: 100%;" onchange="Pilotprereq();" multiple="multiple">
                   
            </select>
       </div>  

       <div class="form__field" id="csocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='CSO' name='CSO' onchange="validateCSO();"><label for='CSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="CSOPREREQS" name="CSOPREREQS" style="width: 100%;" onchange="CSOprereq();" multiple="multiple">
                   
            </select>
       </div> 
           
       <div class="form__field" id="smacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='SMA' name='SMA' onchange="validateSMA();"><label for='SMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="SMAPREREQS" name="SMAPREREQS" style="width: 100%;" onchange="SMAprereq();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field" id="lmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='LM' name='LM'><label for='LM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="LMPREREQS" name="LMPREREQS" style="width: 100%;" onchange="LMprereq();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/editlesson.aspx?type=build" method="post" enctype="multipart/form-data" onsubmit="return checklesson2(this)">
       <input type="hidden" name="editbuildid" id="editbuildid" /> 
       <input type="hidden" name="editid" id="editid" />  
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="EDITDAY" id="EDITDAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="EDITLESSID" name="EDITLESSID" style="width: 100%;" onchange="checkmediatype2();">
                   
            </select>
       </div> 
    
       <div class="form__field" id="EDITreviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITReview' name='EDITReview' onchange='changevalues2();'><label for='EDITReview'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITDURATION" id="EDITDURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPREBRIEF" id="EDITPREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPOSTBRIEF" id="EDITPOSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="EDITMISSIONS" id="EDITMISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="EDITpilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITPILOT' name='EDITPILOT'><label for='EDITPILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITPILOTPREREQS" name="EDITPILOTPREREQS" style="width: 100%;" onchange="Pilotprereq2();" multiple="multiple">
                   
            </select>
       </div>  

       <div class="form__field" id="EDITcsocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITCSO' name='EDITCSO' onchange="validateCSO2();"><label for='EDITCSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITCSOPREREQS" name="EDITCSOPREREQS" style="width: 100%;" onchange="CSOprereq2();" multiple="multiple">
                   
            </select>
       </div> 
           
       <div class="form__field" id="EDITsmacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITSMA' name='EDITSMA' onchange="validateSMA2();"><label for='EDITSMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITSMAPREREQS" name="EDITSMAPREREQS" style="width: 100%;" onchange="SMAprereq2();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field" id="EDITlmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITLM' name='EDITLM'><label for='EDITLM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITLMPREREQS" name="EDITLMPREREQS" style="width: 100%;" onchange="LMprereq2();" multiple="multiple">
                 

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>

<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="../scripts/dataTables.rowReorder.min.js"></script>

<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 
<link rel="stylesheet" href="../styles/rowReorder.dataTables.min.css" /> 

<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />

<script>
    $(document).ready(function () {
        $("#selSOI").select2();       

        var soiid = getUrlVars()["soiid"];

        $('#soiid').val(soiid);
        $('#editsoiid').val(soiid);

        if (soiid != 0) {
            document.getElementById("SOITable").style.display = "inline";         
            document.getElementById("selSOI").value = soiid;
            $("#selSOI").select2();
            loadsoitable();
        }    
    });

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function addurlvariable() {
        var soiid = document.getElementById('selSOI').value;
        window.location.href = "../SOITable/newsoitable.aspx?soiid=" + soiid;
    }

    function loadsoitable() {
        var soiid = getUrlVars()["soiid"]; 
      
        if (soiid == 0) {
            document.getElementById("SOITable").style.display = "none";
        }
        else {
            var table = $('#example').DataTable();
            table.destroy();

            document.getElementById("SOITable").style.display = "inline";
            $("#LESSID").select2();
            $("#PILOTPREREQS").select2({
                placeholder: "Select Pilot Prereqs"
            });
            $("#CSOPREREQS").select2({
                placeholder: "Select CSO Prereqs"
            });
            $("#SMAPREREQS").select2({
                placeholder: "Select SMA Prereqs"
            });
            $("#LMPREREQS").select2({
                placeholder: "Select LM Prereqs"
            });

            $("#EDITLESSID").select2();
            $("#EDITPILOTPREREQS").select2({
                placeholder: "Select Pilot Prereqs"
            });
            $("#EDITCSOPREREQS").select2({
                placeholder: "Select CSO Prereqs"
            });
            $("#EDITSMAPREREQS").select2({
                placeholder: "Select SMA Prereqs"
            });
            $("#EDITLMPREREQS").select2({
                placeholder: "Select LM Prereqs"
            });      

            $.ajax({
                url: 'gettemplate.asmx/GetTemplate?soiid=' + soiid,
                method: 'post',
                dataType: 'json',
                success: function (data) {
                    $('#example').dataTable({
                        "bPaginate": false,
                        "bLengthChange": false,
                        "bFilter": true,
                        "bInfo": true,
                        "bAutoWidth": true,
                        "scrollY": "400px",
                        "sScrollX": "100%",
                        "sScrollXInner": "100%",
                        "scrollCollapse": true,
                        "language": {
                            "emptyTable": "No template saved for this SOI"
                        },
                        data: data,
                        columns: [
                            { 'data': 'ROW' },
                            { 'data': 'DAYSTRING' },
                            { 'data': 'LESSON' },
                            { 'data': 'DURATION' },
                            { 'data': 'PREBRIEF' },
                            { 'data': 'POSTBRIEF' },
                            { 'data': 'NUM_MISSIONS' },
                            { 'data': 'PILOT' },
                            { 'data': 'PILOT_PREREQS' },
                            { 'data': 'CSO' },
                            { 'data': 'CSO_PREREQS' },
                            { 'data': 'SMA' },
                            { 'data': 'SMA_PREREQS' },
                            { 'data': 'LM' },
                            { 'data': 'LM_PREREQS' },
                            { 'data': 'LESSID', "visible": false },
                            { 'data': 'PILOT_PREREQ_LIST', "visible": false },
                            { 'data': 'CSO_PREREQ_LIST', "visible": false },
                            { 'data': 'SMA_PREREQ_LIST', "visible": false },
                            { 'data': 'LM_PREREQ_LIST', "visible": false },
                            { 'data': 'REVIEW', "visible": false },
                            { 'data': 'DAY', "visible": false },
                            { 'data': 'ID', "visible": false }
                        ],
                        columnDefs: [
                            { width: 20, targets: 0 },
                            { width: 20, targets: 1 },
                            { width: 250, targets: 2 },
                            { width: 15, targets: 3 },
                            { width: 15, targets: 4 },
                            { width: 40, targets: 5 },
                            { width: 15, targets: 6 },
                            { width: 20, targets: 7 },
                            { width: 250, targets: 8 },
                            { width: 20, targets: 9 },
                            { width: 250, targets: 10 },
                            { width: 20, targets: 11 },
                            { width: 250, targets: 12 },
                            { width: 20, targets: 13 },
                            { width: 250, targets: 14 },
                            { width: 0, targets: 15 },
                            { width: 0, targets: 16 },
                            { width: 0, targets: 17 },
                            { width: 0, targets: 18 },
                            { width: 0, targets: 19 },
                            { width: 0, targets: 20 },
                            { width: 0, targets: 21 },
                            { width: 0, targets: 22 } 
                        ],
                        fixedColumns: true,
                        rowReorder: {
                            dataSrc: 'ROW',
                            selector: 'tr td:first-of-type'
                        }
                    });
                    var table = $('#example').DataTable();

                    const rowindex = [];
                    const newrows = [];

                    let rowindextext = "";
                    let newrowstext = "";

                    table.on('row-reorder', function (e, diff, edit) {
                        document.getElementById("savebutton").style.display = "inline";
                        var result = "";
                        for (var i = 0, ien = diff.length; i < ien; i++) {
                            result += ' Row ' + diff[i].newData + ' (was ' + diff[i].oldData + ')';
                            rowindex.push(diff[i].oldData);
                            newrows.push(diff[i].newData);
                        }
                        //alert(result);
                        rowindextext = rowindex.toString();
                        newrowstext = newrows.toString();

                        $("#rowindex").val(rowindextext);
                        $("#newrow").val(newrowstext);

                        table.rowReorder.disable();

                        let firstCol = document.querySelectorAll('tr td:first-of-type');
                        for (let i = 0; i < firstCol.length; i++) {
                            firstCol[i].style.cursor = 'auto';
                        }
                    });

                    $('#example tbody').on('click', 'tr', function () {
                        if ($(this).hasClass('selected')) {
                            $(this).removeClass('selected');
                            selid = null;
                        }
                        else {
                            table.$('tr.selected').removeClass('selected');
                            $(this).addClass('selected');
                            var data = table.row(this).data();
                            //const myJSON = JSON.stringify(data);
                            //alert(myJSON);
                            savedata(data);
                        }
                    });
                }
            });
        }  
    }

    var ROW;
    var DAYSTRING;
    var LESSON;
    var DURATION;
    var PREBRIEF;
    var POSTBRIEF;
    var NUM_MISSIONS;
    var PILOT;
    var PILOT_PREREQS;
    var CSO;
    var CSO_PREREQS;
    var SMA;
    var SMA_PREREQS;
    var LM;
    var LM_PRREQS;
    var LESSID;
    var PILOT_PREREQ_LIST;
    var CSO_PREREQ_LIST;
    var SMA_PREREQ_LIST;
    var LM_PREREQ_LIST;
    var REVIEW;
    var DAY;
    var selid;

    function savedata(rowdata) {
        ROW = rowdata.ROW;
        DAYSTRING = rowdata.DAYSTRING;
        LESSON = rowdata.LESSON;
        DURATION = rowdata.DURATION;
        PREBRIEF = rowdata.PREBRIEF;
        POSTBRIEF = rowdata.POSTBRIEF;
        NUM_MISSIONS = rowdata.NUM_MISSIONS;
        PILOT = rowdata.PILOT;
        PILOT_PREREQS = rowdata.PILOT_PREREQS;
        CSO = rowdata.CSO;
        CSO_PREREQS = rowdata.CSO_PREREQS;
        SMA = rowdata.SMA;
        SMA_PREREQS = rowdata.SMA_PREREQS;
        LM = rowdata.LM;
        LM_PREREQS = rowdata.LM_PREREQS;
        LESSID = rowdata.LESSID;
        PILOT_PREREQ_LIST = rowdata.PILOT_PREREQ_LIST;
        CSO_PREREQ_LIST = rowdata.CSO_PREREQ_LIST;
        SMA_PREREQ_LIST = rowdata.SMA_PREREQ_LIST;
        LM_PREREQ_LIST = rowdata.LM_PREREQ_LIST;
        REVIEW = rowdata.REVIEW;
        DAY = rowdata.DAY;
        selid = rowdata.ID;
    }

    function newlesson() {
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }
        var modalcheck = document.getElementById("myModal3");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        // Get the modal
        var modal = document.getElementById("myModal");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }

    function editdata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            setTimeout(function () {
                $('#EDITPILOTPREREQS').select2();
                $('#EDITPILOTPREREQS').select2().val('');
                $('#EDITPILOTPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITCSOPREREQS').select2();
                $('#EDITCSOPREREQS').select2().val('');
                $('#EDITCSOPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITSMAPREREQS').select2();
                $('#EDITSMAPREREQS').select2().val('');
                $('#EDITSMAPREREQS').select2().trigger('change');
            }, 0);
            setTimeout(function () {
                $('#EDITLMPREREQS').select2();
                $('#EDITLMPREREQS').select2().val('');
                $('#EDITLMPREREQS').select2().trigger('change');
            }, 0);

            setTimeout(function () {
                $("#EDITPILOTPREREQS").select2({
                    placeholder: "Select Pilot Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITCSOPREREQS").select2({
                    placeholder: "Select CSO Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITSMAPREREQS").select2({
                    placeholder: "Select SMA Prereqs"
                });
            }, 0);

            setTimeout(function () {
                $("#EDITLMPREREQS").select2({
                    placeholder: "Select LM Prereqs"
                });
            }, 0);

            var modalcheck = document.getElementById("myModal");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }
            var modalcheck = document.getElementById("myModal3");
            if (modalcheck.style.display == "block") {
                modalcheck.style.display = "none";
            }

            // Get the modal
            var modal = document.getElementById("myModal2");
            modal.style.display = "block";

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close2")[0];

            // When the user clicks on <span> (x), close the modal
            span.onclick = function () {
                modal.style.display = "none";
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val('');
                    $('#EDITPILOTPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val('');
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val('');
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val('');
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function (event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0);
                }
            }

            document.onkeydown = function (evt) {
                evt = evt;
                if (evt.key === 'Escape') {
                    modal.style.display = "none";
                    setTimeout(function () {
                        $('#EDITPILOTPREREQS').select2();
                        $('#EDITPILOTPREREQS').select2().val('');
                        $('#EDITPILOTPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITCSOPREREQS').select2();
                        $('#EDITCSOPREREQS').select2().val('');
                        $('#EDITCSOPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITSMAPREREQS').select2();
                        $('#EDITSMAPREREQS').select2().val('');
                        $('#EDITSMAPREREQS').select2().trigger('change');
                    }, 0);
                    setTimeout(function () {
                        $('#EDITLMPREREQS').select2();
                        $('#EDITLMPREREQS').select2().val('');
                        $('#EDITLMPREREQS').select2().trigger('change');
                    }, 0);
                }
            };

            $('#editid').val(selid);
            $('#EDITDAY').val(DAY);

            setTimeout(function () {
                $('#EDITLESSID').select2();
                $('#EDITLESSID').select2().val(LESSID);
                $('#EDITLESSID').select2().trigger('change');
            }, 0);

            $('#EDITDURATION').val(DURATION);
            $('#EDITPREBRIEF').val(PREBRIEF);
            $('#EDITPOSTBRIEF').val(POSTBRIEF);
            $('#EDITMISSIONS').val(NUM_MISSIONS);

            if (PILOT == "True") {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", true);
                }, 0);
            }
            else {
                setTimeout(function () {
                    $("#EDITPILOT").prop("checked", false);
                }, 0);
            }
            if (CSO == "True") {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", true);
                }, 0);
            }
            else {
                setTimeout(function () {
                    $("#EDITCSO").prop("checked", false);
                }, 0);
            }
            if (SMA == "True") {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", true);
                }, 0);
            }
            else {
                setTimeout(function () {
                    $("#EDITSMA").prop("checked", false);
                }, 0);
            }
            if (LM == "True") {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", true);
                }, 0);
            }
            else {
                setTimeout(function () {
                    $("#EDITLM").prop("checked", false);
                }, 0);
            }
            //alert(PILOT_PREREQ_LIST);      
            if (PILOT_PREREQ_LIST != "None") {
                const myData = JSON.parse("[" + PILOT_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITPILOTPREREQS').select2();
                    $('#EDITPILOTPREREQS').select2().val(myData);
                    $('#EDITPILOTPREREQS').select2().trigger('change');
                }, 0);
            }
            if (CSO_PREREQ_LIST != "None") {
                const myData2 = JSON.parse("[" + CSO_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITCSOPREREQS').select2();
                    $('#EDITCSOPREREQS').select2().val(myData2);
                    $('#EDITCSOPREREQS').select2().trigger('change');
                }, 0);
            }
            if (SMA_PREREQ_LIST != "None") {
                const myData3 = JSON.parse("[" + SMA_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITSMAPREREQS').select2();
                    $('#EDITSMAPREREQS').select2().val(myData3);
                    $('#EDITSMAPREREQS').select2().trigger('change');
                }, 0);
            }
            if (LM_PREREQ_LIST != "None") {
                const myData4 = JSON.parse("[" + LM_PREREQ_LIST + "]");
                setTimeout(function () {
                    $('#EDITLMPREREQS').select2();
                    $('#EDITLMPREREQS').select2().val(myData4);
                    $('#EDITLMPREREQS').select2().trigger('change');
                }, 0);
            }

            if (REVIEW == 1) {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", true);
                }, 0);
            }
            else {
                setTimeout(function () {
                    $("#EDITReview").prop("checked", false);
                }, 0);
            }
        }
    }

    function deletedata() {
        if (selid == null) {
            alert("No row selected")
        }
        else {
            var soiid = getUrlVars()["soiid"];
            if (confirm("Are you sure that you want to delete this row?") == true) {
                window.location.href = "../SOITable/deletelesson.aspx?type=template&soiid=" + soiid + "&selid=" + selid;
            } else {
                return;
            }
        }
    }
    function deletealldata() {
        var soiid = getUrlVars()["soiid"];
        if (confirm("Are you sure that you want to delete all rows? This will delete the entire template for this SOI.") == true) {
            window.location.href = "../SOITable/deletetemplate.aspx?soiid=" + soiid;
        } else {
            return;
        }
    }

    function canceldrag() {
        var soiid = getUrlVars()["soiid"];
        window.location.href = "../SOITable/newsoitable.aspx?soiid=" + soiid;
    }

    function backtoactivebuilds() {
        window.location.href = "../SOITable/activesoibuilds.aspx";
    }

    function Pilotprereq() {
        var data = $('#PILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#PILOT").prop("checked", true);
        }
        else {
            $("#PILOT").prop("checked", false);
        }
    }

    function CSOprereq() {
        var data = $('#CSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#CSO").prop("checked", true);
        }
        else {
            $("#CSO").prop("checked", false);
        }
        validateCSO();
    }

    function SMAprereq() {
        var data = $('#SMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#SMA").prop("checked", true);
        }
        else {
            $("#SMA").prop("checked", false);
        }
        validateSMA();
    }

    function LMprereq() {
        var data = $('#LMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#LM").prop("checked", true);
        }
        else {
            $("#LM").prop("checked", false);
        }
    }

    function Pilotprereq2() {
        var data = $('#EDITPILOTPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITPILOT").prop("checked", true);
        }
        else {
            $("#EDITPILOT").prop("checked", false);
        }
    }

    function CSOprereq2() {
        var data = $('#EDITCSOPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITCSO").prop("checked", true);
        }
        else {
            $("#EDITCSO").prop("checked", false);
        }
        validateCSO2();
    }

    function SMAprereq2() {
        var data = $('#EDITSMAPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITSMA").prop("checked", true);
        }
        else {
            $("#EDITSMA").prop("checked", false);
        }
        validateSMA2();
    }

    function LMprereq2() {
        var data = $('#EDITLMPREREQS').val();
        //alert(data);
        if (data != "") {
            $("#EDITLM").prop("checked", true);
        }
        else {
            $("#EDITLM").prop("checked", false);
        }
    }

    function validateSMA() {
        if ($("#SMA").is(':checked')) {
            $("#CSO").prop("checked", false);
        }
    }
    function validateCSO() {
        if ($("#CSO").is(':checked')) {
            $("#SMA").prop("checked", false);
        }
    }

    function validateSMA2() {
        if ($("#EDITSMA").is(':checked')) {
            $("#EDITCSO").prop("checked", false);
        }
    }
    function validateCSO2() {
        if ($("#EDITCSO").is(':checked')) {
            $("#EDITSMA").prop("checked", false);
        }
    }

    function checkmediatype() {
        //alert(rowCnt);
        var lessid = $('#LESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#DURATION').val();
        var prebrief = $('#PREBRIEF').val();
        var postbrief = $('#POSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#reviewcheckbox")[0].style.display = 'flex';

                    if ($("#Review").is(':checked')) {
                        $("#DURATION")[0].type = 'text';
                        $("#DURATION")[0].style.backgroundColor = 'black';
                        $("#DURATION").val('R');
                        $("#DURATION").prop("readonly", true);
                        /*
                        $("#PREBRIEF")[0].type = 'text';
                        $("#PREBRIEF")[0].style.backgroundColor = 'black';
                        $("#PREBRIEF").val('R');
                        $("#PREBRIEF").prop("readonly", true);

                        $("#POSTBRIEF")[0].type = 'text';
                        $("#POSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#POSTBRIEF").val('R');
                        $("#POSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#DURATION")[0].type = 'number';
                            $("#DURATION")[0].style.backgroundColor = '#3b4148';
                            $("#DURATION").val('0');
                            $("#DURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#PREBRIEF")[0].type = 'number';
                            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#PREBRIEF").val('0');
                            $("#PREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#POSTBRIEF")[0].type = 'number';
                            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#POSTBRIEF").val('0');
                            $("#POSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#reviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#DURATION")[0].type = 'number';
                        $("#DURATION")[0].style.backgroundColor = '#3b4148';
                        $("#DURATION").val('0');
                        $("#DURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#PREBRIEF")[0].type = 'number';
                        $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#PREBRIEF").val('0');
                        $("#PREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#POSTBRIEF")[0].type = 'number';
                        $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#POSTBRIEF").val('0');
                        $("#POSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#reviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#DURATION")[0].type = 'number';
                $("#DURATION")[0].style.backgroundColor = '#3b4148';
                $("#DURATION").val('0');
                $("#DURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#PREBRIEF")[0].type = 'number';
                $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#PREBRIEF").val('0');
                $("#PREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#POSTBRIEF")[0].type = 'number';
                $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#POSTBRIEF").val('0');
                $("#POSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function checkmediatype2() {
        //alert(rowCnt);
        var lessid = $('#EDITLESSID').val();
        if (lessid == "") {
            return false;
        }

        var duration = $('#EDITDURATION').val();
        var prebrief = $('#EDITPREBRIEF').val();
        var postbrief = $('#EDITPOSTBRIEF').val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");
                    $("#EDITreviewcheckbox")[0].style.display = 'flex';

                    if ($("#EDITReview").is(':checked')) {
                        $("#EDITDURATION")[0].type = 'text';
                        $("#EDITDURATION")[0].style.backgroundColor = 'black';
                        $("#EDITDURATION").val('R');
                        $("#EDITDURATION").prop("readonly", true);
                        /*
                        $("#EDITPREBRIEF")[0].type = 'text';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPREBRIEF").val('R');
                        $("#EDITPREBRIEF").prop("readonly", true);

                        $("#EDITPOSTBRIEF")[0].type = 'text';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
                        $("#EDITPOSTBRIEF").val('R');
                        $("#EDITPOSTBRIEF").prop("readonly", true);
                        */
                    }
                    else {
                        if (duration == 0 || duration == "R") {
                            $("#EDITDURATION")[0].type = 'number';
                            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                            $("#EDITDURATION").val('0');
                            $("#EDITDURATION").prop("readonly", false);
                        }
                        /*
                        if (prebrief == 0 || prebrief == "R") {
                            $("#EDITPREBRIEF")[0].type = 'number';
                            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPREBRIEF").val('0');
                            $("#EDITPREBRIEF").prop("readonly", false);
                        }
                        if (postbrief == 0 || postbrief == "R") {
                            $("#EDITPOSTBRIEF")[0].type = 'number';
                            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                            $("#EDITPOSTBRIEF").val('0');
                            $("#EDITPOSTBRIEF").prop("readonly", false);
                        }
                        */
                    }
                }
                else {
                    $("#EDITreviewcheckbox")[0].style.display = 'none';

                    if (duration == 0 || duration == "R") {
                        $("#EDITDURATION")[0].type = 'number';
                        $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                        $("#EDITDURATION").val('0');
                        $("#EDITDURATION").prop("readonly", false);
                    }
                    /*
                    if (prebrief == 0 || prebrief == "R") {
                        $("#EDITPREBRIEF")[0].type = 'number';
                        $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPREBRIEF").val('0');
                        $("#EDITPREBRIEF").prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#EDITPOSTBRIEF")[0].type = 'number';
                        $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                        $("#EDITPOSTBRIEF").val('0');
                        $("#EDITPOSTBRIEF").prop("readonly", false);
                    }
                    */
                }
            });
        }
        else {
            $("#EDITreviewcheckbox")[0].style.display = 'none';

            if (duration == 0 || duration == "R") {
                $("#EDITDURATION")[0].type = 'number';
                $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
                $("#EDITDURATION").val('0');
                $("#EDITDURATION").prop("readonly", false);
            }
            /*
            if (prebrief == 0 || prebrief == "R") {
                $("#EDITPREBRIEF")[0].type = 'number';
                $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPREBRIEF").val('0');
                $("#EDITPREBRIEF").prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#EDITPOSTBRIEF")[0].type = 'number';
                $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
                $("#EDITPOSTBRIEF").val('0');
                $("#EDITPOSTBRIEF").prop("readonly", false);
            }
            */
        }
    }

    function changevalues() {
        if ($("#Review").is(':checked')) {
            $("#DURATION")[0].type = 'text';
            $("#DURATION")[0].style.backgroundColor = 'black';
            $("#DURATION").val('R');
            $("#DURATION").prop("readonly", true);
            /*
            $("#PREBRIEF")[0].type = 'text';
            $("#PREBRIEF")[0].style.backgroundColor = 'black';
            $("#PREBRIEF").val('R');
            $("#PREBRIEF").prop("readonly", true);

            $("#POSTBRIEF")[0].type = 'text';
            $("#POSTBRIEF")[0].style.backgroundColor = 'black';
            $("#POSTBRIEF").val('R');
            $("#POSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#DURATION")[0].type = 'number';
            $("#DURATION")[0].style.backgroundColor = '#3b4148';
            $("#DURATION").val('0');
            $("#DURATION").prop("readonly", false);
            /*
            $("#PREBRIEF")[0].type = 'number';
            $("#PREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#PREBRIEF").val('0');
            $("#PREBRIEF").prop("readonly", false);

            $("#POSTBRIEF")[0].type = 'number';
            $("#POSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#POSTBRIEF").val('0');
            $("#POSTBRIEF").prop("readonly", false);
            */
        }
    }

    function changevalues2() {
        if ($("#EDITReview").is(':checked')) {
            $("#EDITDURATION")[0].type = 'text';
            $("#EDITDURATION")[0].style.backgroundColor = 'black';
            $("#EDITDURATION").val('R');
            $("#EDITDURATION").prop("readonly", true);
            /*
            $("#EDITPREBRIEF")[0].type = 'text';
            $("#EDITPREBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPREBRIEF").val('R');
            $("#EDITPREBRIEF").prop("readonly", true);

            $("#EDITPOSTBRIEF")[0].type = 'text';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = 'black';
            $("#EDITPOSTBRIEF").val('R');
            $("#EDITPOSTBRIEF").prop("readonly", true);
            */
        }
        else {
            $("#EDITDURATION")[0].type = 'number';
            $("#EDITDURATION")[0].style.backgroundColor = '#3b4148';
            $("#EDITDURATION").val('0');
            $("#EDITDURATION").prop("readonly", false);
            /*
            $("#EDITPREBRIEF")[0].type = 'number';
            $("#EDITPREBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPREBRIEF").val('0');
            $("#EDITPREBRIEF").prop("readonly", false);

            $("#EDITPOSTBRIEF")[0].type = 'number';
            $("#EDITPOSTBRIEF")[0].style.backgroundColor = '#3b4148';
            $("#EDITPOSTBRIEF").val('0');
            $("#EDITPOSTBRIEF").prop("readonly", false);
            */
        }
    }

    function savebuild() {
        var soiid = getUrlVars()["soiid"];
        window.location.href = "../SOITable/savebuild.aspx?soiid=" + soiid;
    }

    function checklesson(form) {
        var lessoncheck = form.LESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }

    function checklesson2(form) {
        var lessoncheck = form.EDITLESSID.value;

        if (lessoncheck == "") {
            alert("Lesson dropdown field is required!");
            return false;
        }
    }

    function importdata() {
        var table = $('#example').DataTable();

        if (!table.data().any()) {
            //Do nothing
        }
        else {
            alert("ERROR: Table must not contain rows to import data. Delete all rows first, then import.");
            return false;
        }

        var modalcheck = document.getElementById("myModal");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }
        var modalcheck = document.getElementById("myModal2");
        if (modalcheck.style.display == "block") {
            modalcheck.style.display = "none";
        }

        var soiid = getUrlVars()["soiid"];
        $('#importsoiid').val(soiid);
        // Get the modal
        var modal = document.getElementById("myModal3");
        modal.style.display = "block";

        // Get the <span> element that closes the modal
        var span = document.getElementsByClassName("close3")[0];

        // When the user clicks on <span> (x), close the modal
        span.onclick = function () {
            modal.style.display = "none";
        }

        // When the user clicks anywhere outside of the modal, close it
        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

        document.onkeydown = function (evt) {
            evt = evt;
            if (evt.key === 'Escape') {
                modal.style.display = "none";
            }
        };
    }
</script>

<style>
table tr td:first-of-type {
  cursor: move;  
}
table tr td{
  text-align: center;
}

#main {
    overflow-x: hidden;
}

@media screen and (max-width: 1300px) {  
  #myModal{
        width: 580px;
        min-width: 580px;
        font-size: 10px;
    }
  #myModal2{
        width: 580px;
        min-width: 580px;
        font-size: 10px;    
    }
  #myModal3{
        width: 580px;
    }
}

.modal{
    width: 1700px;
}
#pilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#PILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#pilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#csocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#CSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#csocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#smacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#SMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#smacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#lmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#LM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#lmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#reviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#Review{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#reviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

#EDITpilotcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 130px;
}
#EDITPILOT{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITpilotcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITcsocheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITCSO{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITcsocheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITsmacheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 118px;
}
#EDITSMA{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITsmacheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITlmcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 105px;
}
#EDITLM{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITlmcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}
#EDITreviewcheckbox{
    background-color: #3b4148;
    border-radius: 0.25rem;
    margin-left: 188px;
    width: 138px;
}
#EDITReview{
    font-weight: bold;
    font-size: 20px;
    width: 70px;
}
#EDITreviewcheckbox label{
    padding: 5px;
    padding-top: 15px;
    padding-bottom: 15px;
}

.InfoTitles{
    margin-top: 13px;
    float: left;
    width: 200px;
    color: black;
    text-align: right;
}

.select2-search__field {
    color: black;
}

.buttonred {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkred;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttonred:focus,
.buttonred:hover {
    background-color: darkred;
    color: white
}

.buttongreen {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: darkgreen;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 16px;
    padding: 1rem;
    cursor: pointer;
}

.buttongreen:focus,
.buttongreen:hover {
    background-color: darkgreen;
    color: white
}

.editlink{
    font-size: small;
    text-decoration: none;
    line-height: 30px;
}
.editlink:hover{
    text-decoration: underline;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>New SOI Build<br /><span style="color: #005EB8">
    </select>
    <a class='editlink' href='../CAT/EditSOI.aspx'>(edit list)</a>
</div>

<div id="SOITable" style="display: none;">
<div style="margin-left: 35px; margin-top: 10px; margin-bottom: -20px; min-width: 600px;">
    <button class="buttongreen" onclick="savebuild()">Save Template As Build</button>
    <button class="buttongreen" onclick="importdata()">Import</button>
    <br /><br />
    <button class="button" onclick="newlesson()">Add Row</button>
    <button class="button" onclick="editdata()">Edit Row</button>
    <button class="button" onclick="deletedata()">Delete Row</button>
    &nbsp;&nbsp;&nbsp;
    <button class="button" onclick="deletealldata()">Delete All Rows</button> 
</div>
<br /><br />



<div style="margin-left: 35px; margin-right: 35px;">
<table id="example" class="display" style="width:100%; border: none;">
        <thead style="background-color: #005EB8; color: white">
            <tr>    
                <th>Order</th>
                <th>Day</th>
                <th>Lesson</th>    
                <th>Duration</th>   
                <th>Pre Brief</th> 
                <th>Post Brief</th> 
                <th># of Missions</th> 
                <th>Pilot</th>
                <th>Pilot Prereqs</th> 
                <th>CSO</th> 
                <th>CSO Prereqs</th> 
                <th>SMA</th>             
                <th>SMA Prereqs</th>        
                <th>LM</th>
                <th>LM Prereqs</th> 
                <th>LESSID</th>
                <th>Pilot Prereqs List</th>
                <th>CSO Prereqs List</th>
                <th>SMA Prereqs List</th>
                <th>LM Prereqs List</th>
                <th>ID</th> 
            </tr>
        </thead>
        <tbody>                    
        </tbody>
    </table>
</div>
</div>

<!-- The Modal -->
<div id="myModal" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Add Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/newlesson.aspx?type=template" method="post" enctype="multipart/form-data" onsubmit="return checklesson(this)">
       <input type="hidden" name="soiid" id="soiid" /> 
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="DAY" id="DAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="LESSID" name="LESSID" style="width: 100%;" onchange="checkmediatype();">
                   
            </select>
       </div> 
    
       <div class="form__field" id="reviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='Review' name='Review' onchange='changevalues();'><label for='Review'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="DURATION" id="DURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="PREBRIEF" id="PREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="POSTBRIEF" id="POSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="MISSIONS" id="MISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="pilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='PILOT' name='PILOT'><label for='PILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="PILOTPREREQS" name="PILOTPREREQS" style="width: 100%;" onchange="Pilotprereq();" multiple="multiple">
                   
            </select>
       </div>  

       <div class="form__field" id="csocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='CSO' name='CSO' onchange="validateCSO();"><label for='CSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="CSOPREREQS" name="CSOPREREQS" style="width: 100%;" onchange="CSOprereq();" multiple="multiple">
                   
            </select>
       </div> 
           
       <div class="form__field" id="smacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='SMA' name='SMA' onchange="validateSMA();"><label for='SMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="SMAPREREQS" name="SMAPREREQS" style="width: 100%;" onchange="SMAprereq();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field" id="lmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='LM' name='LM'><label for='LM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="LMPREREQS" name="LMPREREQS" style="width: 100%;" onchange="LMprereq();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field">
       <input type="submit" value="Submit" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>

<!-- The Modal -->
<div id="myModal2" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">
    <span class="close2">&times;</span>
      <br /><br />
       <h4 style="text-align: center">Edit Row</h4><br />
       <form class="form login" name="form1" action="../SOITable/editlesson.aspx?type=template" method="post" enctype="multipart/form-data" onsubmit="return checklesson2(this)">
       <input type="hidden" name="editsoiid" id="editsoiid" /> 
       <input type="hidden" name="editid" id="editid" />  
       <div class="form__field">
       <div class='InfoTitles'>Day:&nbsp;</div><input style="color: white;" type="number" min="1" name="EDITDAY" id="EDITDAY" placeholder="Day" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Lesson:&nbsp;</div>
            <select class="selectstyle" id="EDITLESSID" name="EDITLESSID" style="width: 100%;" onchange="checkmediatype2();">
                   
            </select>
       </div> 
    
       <div class="form__field" id="EDITreviewcheckbox" style="display: none" >
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITReview' name='EDITReview' onchange='changevalues2();'><label for='EDITReview'>Review&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>

       <div class="form__field">
       <div class='InfoTitles'>Duration:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITDURATION" id="EDITDURATION" placeholder="Duration" required="required"/>
       </div> 
       <div class="form__field">
       <div class='InfoTitles'>Pre Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPREBRIEF" id="EDITPREBRIEF" placeholder="Pre Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'>Post Brief:&nbsp;</div><input style="color: white;" type="number" min="0" step="0.1" value="0" name="EDITPOSTBRIEF" id="EDITPOSTBRIEF" placeholder="Post Brief" required="required"/>
       </div>
       <div class="form__field">
       <div class='InfoTitles'># of Missions:&nbsp;</div><input style="color: white;" type="number" min="0" value="0" name="EDITMISSIONS" id="EDITMISSIONS" placeholder="# of Missions" required="required"/>
       </div> 

       <div class="form__field" id="EDITpilotcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITPILOT' name='EDITPILOT'><label for='EDITPILOT'>PILOT&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>Pilot Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITPILOTPREREQS" name="EDITPILOTPREREQS" style="width: 100%;" onchange="Pilotprereq2();" multiple="multiple">
                   
            </select>
       </div>  

       <div class="form__field" id="EDITcsocheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITCSO' name='EDITCSO' onchange="validateCSO2();"><label for='EDITCSO'>CSO&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>CSO Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITCSOPREREQS" name="EDITCSOPREREQS" style="width: 100%;" onchange="CSOprereq2();" multiple="multiple">
                   
            </select>
       </div> 
           
       <div class="form__field" id="EDITsmacheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITSMA' name='EDITSMA' onchange="validateSMA2();"><label for='EDITSMA'>SMA&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>SMA Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITSMAPREREQS" name="EDITSMAPREREQS" style="width: 100%;" onchange="SMAprereq2();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field" id="EDITlmcheckbox">
       &nbsp;&nbsp;&nbsp;&nbsp;<input type='checkbox' id='EDITLM' name='EDITLM'><label for='EDITLM'>LM&nbsp;&nbsp;&nbsp;&nbsp;</label>
       </div>
       <div class="form__field" style="color: black;">
       <div class='InfoTitles'>LM Prereqs:&nbsp;</div>
            <select class="selectstyle" id="EDITLMPREREQS" name="EDITLMPREREQS" style="width: 100%;" onchange="LMprereq2();" multiple="multiple">
                   
            </select>
       </div> 

       <div class="form__field">
       <input type="submit" value="Update" style="width: 300px;" />
       </div>          
       </form>
  </div>  
</div>

<!-- The Modal -->
<div id="myModal3" class="modal">
  <!-- Modal content -->
  <div class="modal-content" style="background-color: lightgray;">    
    <span class="close3">&times;</span>
    <br /><br />
    <h4 style="text-align: center">Import Data</h4><br /> 
       <form class="form login" name="form1" action="../SOITable/importSOITemplatedata.aspx" method="post" enctype="multipart/form-data" >
       <input type="hidden" name="importsoiid" id="importsoiid" />  
       <div class="form__field"> 
            <input style="color: black; margin-left: 30px;" type="file" id="myfile" name="myfile" required="required">
       </div>    
       <div class="form__field">
       <input type="submit" value="Import" style="width: 300px;" />
       </div>          
       </form>
  </div>
</div>


<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" />
<meta http-equiv='cache-control' content='no-cache'>
<meta http-equiv='expires' content='0'>
<meta http-equiv='pragma' content='no-cache'>
<script>
    $(document).ready(function () {  
        createTable();
    });

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function loadsoitable() {
        var timeoutvalue = 1000;
        $("#empTable tr").remove();
        var buildid = getUrlVars()["buildid"];
        //use get method to get the build data   
        $.get("../SOITable/getbuilddata.aspx?buildid=" + buildid, function (data) {
            //alert(data);
            const myArray = data.split("<!DOCTYPE html>");
            var data = myArray[0];
            //alert(data);
            if (data == 0) {
                //No build for this SOI
                alert("Error: No build data found!");
            }
            else {
                //Populate table with build data
                //alert(data);
                const myData = data.split("^");
                const myData2 = data.split("^");
                const myData3 = data.split("^");
                const myData4 = data.split("^");
                //alert(myData.length);
                if (myData.length <= 10) {
                    timeoutvalue = 1000;
                }
                else if (myData.length > 10 && myData.length <= 15) {
                    timeoutvalue = 2000;
                }
                else if (myData.length > 15 && myData.length <= 20) {
                    timeoutvalue = 3000;
                }
                else if (myData.length > 20 && myData.length <= 25) {
                    timeoutvalue = 4000;
                }
                else if (myData.length > 25 && myData.length <= 30) {
                    timeoutvalue = 5000;
                }
                else if (myData.length > 30 && myData.length <= 35) {
                    timeoutvalue = 6000;
                }
                else if (myData.length > 35 && myData.length <= 40) {
                    timeoutvalue = 7000;
                }
                else if (myData.length > 40 && myData.length <= 45) {
                    timeoutvalue = 8000;
                }
                else if (myData.length > 45 && myData.length <= 50) {
                    timeoutvalue = 15000;
                }
                else if (myData.length > 50 && myData.length <= 55) {
                    timeoutvalue = 16000;
                }
                else if (myData.length > 55 && myData.length <= 60) {
                    timeoutvalue = 17000;
                }
                else if (myData.length > 60 && myData.length <= 65) {
                    timeoutvalue = 18000;
                }
                else if (myData.length > 65 && myData.length <= 70) {
                    timeoutvalue = 19000;
                }
                else if (myData.length > 70 && myData.length <= 75) {
                    timeoutvalue = 20000;
                }
                else if (myData.length > 75 && myData.length <= 80) {
                    timeoutvalue = 21000;
                }
                else {  //myData.length > 80
                    timeoutvalue = 22000;
                }
                //alert(timeoutvalue);
  
                for (let i = 0; i < myData.length - 1; i++) {
                    //alert(myData[i]);
                    var optdata = myData[i];
                    const optvalue = optdata.split("~");
                    //alert(optvalue[0]);
                    //alert(optvalue[1]);
                    addRow();     
                    
                    $('#day' + i).val(optvalue[0]);
                    setTimeout(function () {
                        $('#lessonsel' + i).select2();
                        $('#lessonsel' + i).select2().val(optvalue[1]);
                        $('#lessonsel' + i).select2().trigger('change');
                    }, timeoutvalue);
                    $('#duration' + i).val(optvalue[2]);
                    $('#prebrief' + i).val(optvalue[3]);
                    $('#postbrief' + i).val(optvalue[4]);
                    $('#mission' + i).val(optvalue[5]);
                    //alert(optvalue[6]);
                    //var pcslarray = optvalue[6].split(',');
                    //alert(pcslarray[0]);  //Pilot
                    //alert(pcslarray[1]);  //CSO
                    //alert(pcslarray[2]);  //SMA
                    //alert(pcslarray[3]);  //LM             
                    if (optvalue[6] == "True") {
                        $("#Pilot" + i).prop("checked", true);
                    }
                    else {
                        $("#Pilot" + i).prop("checked", false);
                    }
                    if (optvalue[8] == "True") {
                        $("#CSO" + i).prop("checked", true);
                    }
                    else {
                        $("#CSO" + i).prop("checked", false);
                    }
                    if (optvalue[10] == "True") {
                        $("#SMA" + i).prop("checked", true);
                    }
                    else {
                        $("#SMA" + i).prop("checked", false);
                    }
                    if (optvalue[12] == "True") {
                        $("#LM" + i).prop("checked", true);
                    }
                    else {
                        $("#LM" + i).prop("checked", false);
                    }

                    if (optvalue[7] == "None") {
  
                    }
                    else {
                        //create unique array
                        myData[i] = JSON.parse("[" + optvalue[7] + "]");
                        setTimeout(function () {
                            $('#pilotprereq' + i).select2();
                            $('#pilotprereq' + i).select2().val(myData[i]);
                            $('#pilotprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }

                    if (optvalue[9] == "None") {

                    }
                    else {
                        //create unique array
                        myData2[i] = JSON.parse("[" + optvalue[9] + "]");
                        setTimeout(function () {
                            $('#csoprereq' + i).select2();
                            $('#csoprereq' + i).select2().val(myData2[i]);
                            $('#csoprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }


                    if (optvalue[11] == "None") {

                    }
                    else {
                        //create unique array
                        myData3[i] = JSON.parse("[" + optvalue[11] + "]");
                        setTimeout(function () {
                            $('#smaprereq' + i).select2();
                            $('#smaprereq' + i).select2().val(myData3[i]);
                            $('#smaprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }

                    if (optvalue[13] == "None") {

                    }
                    else {
                        //create unique array
                        myData4[i] = JSON.parse("[" + optvalue[13] + "]");
                        setTimeout(function () {
                            $('#lmprereq' + i).select2();
                            $('#lmprereq' + i).select2().val(myData4[i]);
                            $('#lmprereq' + i).select2().trigger('change');
                        }, timeoutvalue);
                    }                     
                }  
            }
        });
    }

    var removerowcounter = 0;
    var removedrow = 0;

    // Start ---> Must keep this code here even though it isn't really being used
    let arrHead = new Array();
    arrHead = ['', 'Day', 'Lesson', 'Duration', 'Pre Brief', 'Post Brief', '# of Missions', 'Pilot', 'Pilot Prereqs', 'CSO', 'CSO Prereqs', 'SMA', 'SMA Prereqs', 'LM', 'LM Prereqs'];      // table headers.

    // first create a TABLE structure by adding few headers.
    let createTable = () => {
        let empTable = document.createElement('table');
        empTable.setAttribute('id', 'empTable');  // table id.       
        let tr = empTable.insertRow(-1);
        for (let h = 0; h < arrHead.length; h++) {            
            let th = document.createElement('th'); // the header object.
            tr.setAttribute('id', 'tableheader');
            th.setAttribute('class', 'column' + h);
            th.innerHTML = arrHead[h];
            th.style.backgroundColor = "#005EB8";
            th.style.color = "white"; 
            //tr.appendChild(th);  //Removed the header because it was not working properly with drag and drop
        }

        let div = document.getElementById('cont');
        div.appendChild(empTable);    // add table to a container.
        loadsoitable();
    }
    // End ---> Must keep this code here even though it isn't really being used

    // function to add new row.
    let addRow = () => {
        document.getElementById('addRow').style.backgroundColor = "transparent";
        document.getElementById('addRow').style.color = "black";
        document.getElementById("addRow").addEventListener("mouseover", function () {
            document.getElementById("addRow").style.backgroundColor = "#005EB8";
            document.getElementById("addRow").style.color = "white";
        });

        document.getElementById("addRow").addEventListener("mouseout", function () {
            document.getElementById("addRow").style.backgroundColor = "transparent";
            document.getElementById("addRow").style.color = "black";
        });

        let empTab = document.getElementById('empTable');
        empTab.setAttribute('class', 'table-dragable');
        let rowCnt = empTab.rows.length;    // get the number of rows.

        if (removerowcounter != 0) {
            //alert(removerowcounter);
            for (let j = 0; j <= rowCnt; j++) {
                if ($('#rownumber' + j).length === 0) {
                    //alert("Row " + j + " added.");
                    rowCnt = j;
                }
                else {
                    //alert("Row " + j + " already exists.");
                }
            }
            removerowcounter = removerowcounter - 1;
        } 

        let tr = empTab.insertRow(rowCnt); // table row.
        tr.setAttribute('id', 'rownumber' + rowCnt);
        tr.setAttribute('class', 'grabable');

        $('.table-dragable tbody .grabable').mousedown(function (e) {
            var tr = $(e.target).closest('tr'), sy = e.pageY, drag;
            if ($(e.target).is('tr')) tr = $(e.target);
            var index = tr.index();
            $(tr).addClass('grabbed');
            function move(e) {
                if (!drag && Math.abs(e.pageY - sy) < 10) return;
                drag = true;
                tr.siblings().each(function () {
                    var s = $(this), i = s.index(), y = s.offset().top;
                    if (e.pageY >= y && e.pageY < y + s.outerHeight()) {
                        if (i < tr.index()) {
                            s.insertAfter(tr);
                        }
                        else {
                            s.insertBefore(tr);
                        }
                        return false;
                    }
                });
            }
            function up(e) {
                if (drag && index != tr.index()) {
                    drag = false;
                }
                $(document).unbind('mousemove', move).unbind('mouseup', up);
                $(tr).removeClass('grabbed');
            }
            $(document).mousemove(move).mouseup(up);
        });

        for (let c = 0; c < arrHead.length; c++) {
            let td = document.createElement('td');          // table definition.
            td = tr.insertCell(c);

            if (c == 0) {   // if its the first column of the table.
                // add a button control.
                const button = document.createElement('input');

                // set the attributes.
                if (rowCnt != 0) {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('onclick', 'removeRow(this)');
                    td.appendChild(button);
                }
                else {
                    button.setAttribute('type', 'button');
                    button.setAttribute('class', 'removebutton');
                    button.setAttribute('value', 'Remove');
                    button.setAttribute('style', 'visibility: hidden');
                    td.appendChild(button);
                }
            }
            else if (c == 1) {
                // 2nd column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '1');
                ele.setAttribute('id', 'day' + rowCnt);
                ele.setAttribute('class', 'dayinput');
                //alert(rowCnt);
                if (rowCnt == 0) {
                    ele.setAttribute('value', '1');
                    ele.setAttribute('readonly', 'readonly');
                }
                else {
                    ele.setAttribute('value', '');
                }
                td.appendChild(ele);
            }
            else if (c == 2) {
                // 3rd column will have dropdown
                const ele = document.createElement('select');
                ele.setAttribute('class', 'lessonselect');
                ele.setAttribute('id', 'lessonsel' + rowCnt);
                ele.value = "Select Lesson";
                ele.add(new Option("Select Lesson"));
                ele.setAttribute('onchange', 'checkmediatype(' + rowCnt + ')');
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        //option.text = optvalue[1] + " <" + optvalue[0] + ">";
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".lessonselect").select2();
            }
            else if (c == 3) {
                // 4th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'durationinput');
                ele.setAttribute('id', 'duration' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 4) {
                // 5th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'prebriefinput');
                ele.setAttribute('id', 'prebrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 5) {
                // 6th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('step', '0.1');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'postbriefinput');
                ele.setAttribute('id', 'postbrief' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 6) {
                // 7th column will have textbox.
                const ele = document.createElement('input');
                ele.setAttribute('type', 'number');
                ele.setAttribute('min', '0');
                ele.setAttribute('value', '0');
                ele.setAttribute('class', 'missioninput');
                ele.setAttribute('id', 'mission' + rowCnt);
                td.appendChild(ele);
            }
            else if (c == 7) {
                // 8th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "Pilot";
                checkbox.value = "Pilot";
                checkbox.id = "Pilot" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' Pilot '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 8) {
                // 9th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(8).setAttribute("id", "pilottd" + rowCnt);
                ele.setAttribute('class', 'pilotprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'pilotprereq' + rowCnt);
                ele.setAttribute('onchange', 'Pilotprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".pilotprereqsel").select2({
                    placeholder: "Select Pilot Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#pilotprereq' + rowCnt).select2();
                    $('#pilotprereq' + rowCnt).select2().val("None");
                    $('#pilotprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 9) {
                // 10th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "CSO";
                checkbox.value = "CSO";
                checkbox.id = "CSO" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateCSO(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' CSO '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 10) {
                // 11th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(10).setAttribute("id", "csotd" + rowCnt);
                ele.setAttribute('class', 'csoprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'csoprereq' + rowCnt);
                ele.setAttribute('onchange', 'CSOprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".csoprereqsel").select2({
                    placeholder: "Select CSO Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#csoprereq' + rowCnt).select2();
                    $('#csoprereq' + rowCnt).select2().val("None");
                    $('#csoprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 11) {
                // 12th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "SMA";
                checkbox.value = "SMA";
                checkbox.id = "SMA" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                checkbox.setAttribute('onclick', 'validateSMA(' + rowCnt + ')');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' SMA '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 12) {
                // 13th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(12).setAttribute("id", "smatd" + rowCnt);
                ele.setAttribute('class', 'smaprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'smaprereq' + rowCnt);
                ele.setAttribute('onchange', 'SMAprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".smaprereqsel").select2({
                    placeholder: "Select SMA Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#smaprereq' + rowCnt).select2();
                    $('#smaprereq' + rowCnt).select2().val("None");
                    $('#smaprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
            else if (c == 13) {
                // 14th column will have check box
                var checkboxdiv = document.createElement('div');
                checkboxdiv.style.minWidth = "70px";
                var checkbox = document.createElement('input');
                checkbox.type = "checkbox";
                checkbox.name = "LM";
                checkbox.value = "LM";
                checkbox.id = "LM" + rowCnt;
                checkbox.setAttribute('class', 'cbclass');
                var label = document.createElement('label');
                label.appendChild(document.createTextNode(' LM '));
                label.setAttribute('class', 'checkboxlabels');
                td.appendChild(checkbox);
                td.appendChild(label);
                td.appendChild(checkboxdiv);
            }
            else if (c == 14) {
                // 15th column will have dropdown
                const ele = document.createElement('select');
                empTab.rows[rowCnt].cells.item(14).setAttribute("id", "lmtd" + rowCnt);
                ele.setAttribute('class', 'lmprereqsel');
                ele.setAttribute('multiple', 'multiple');
                ele.setAttribute('id', 'lmprereq' + rowCnt);
                ele.setAttribute('onchange', 'LMprereq(' + rowCnt + ')');
                //ele.value = "0";
                //ele.add(new Option("None"));
                $.get("../SOITable/getlessons.aspx", function (data) {
                    //alert(data);
                    const myArray = data.split("<!DOCTYPE html>");
                    var data = myArray[0];
                    //alert(myArray[0]); 
                    const myData = data.split("^");

                    for (let i = 0; i < myData.length - 1; i++) {
                        //alert(myData[i]);  
                        var optdata = myData[i];
                        const optvalue = optdata.split("~");
                        var option = document.createElement("option");
                        option.value = optvalue[0];
                        option.text = optvalue[1];
                        ele.add(option);
                    }
                });
                td.appendChild(ele);
                $(".lmprereqsel").select2({
                    placeholder: "Select LM Prereqs"
                });
                /*
                setTimeout(function () {
                    $('#lmprereq' + rowCnt).select2();
                    $('#lmprereq' + rowCnt).select2().val("None");
                    $('#lmprereq' + rowCnt).select2().trigger('change');
                }, 1000);
                */
            }
        }
    }

    // function to delete a row.
    let removeRow = (oButton) => {
        let empTab = document.getElementById('empTable');
        removedrow = oButton.parentNode.parentNode.rowIndex;
        //alert(removedrow);
        empTab.deleteRow(oButton.parentNode.parentNode.rowIndex); // buttton -> td -> tr
        removerowcounter++;
    }

    // function to extract and submit table data.
    let submit = () => {        
        let myTab = document.getElementById('empTable');
        let arrValues = new Array();

        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id); 
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');
                                //var rowid = cell.childNodes[0].id.slice(-1);   
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(rowid);                                
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }
                                //alert(values);
                                arrValues.push(values);
                            }
                            else if (cell.childNodes[0].type == 'checkbox') {
                                //alert(cell.childNodes[0].id);
                                //var nodeid = cell.childNodes[0].id.slice(0, -1);
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";
                                var SMA = "False";
                                var LM = "False";
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }
                        }
                        else {
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }

        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");       
        //alert(arrValues);
                
        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }       

        var buildid = getUrlVars()["buildid"];  
        $('#tabledata').val(arrValues);
        $('#buildid').val(buildid);
        document.getElementById("savedata").submit(); // Submitting form
    }   

    let submit2 = () => {
        let text = "Are you sure that you want to proceed? This will overwrite the saved template if one is already saved for this SOI.";
        if (confirm(text) == true) {
            //do nothing
        } else {
            return;
        }

        let myTab = document.getElementById('empTable');
        let arrValues = new Array();

        // loop through each row of the table.
        for (let row of myTab.rows) {
            for (let cell of row.cells) {
                if (cell.childNodes[0] != undefined) {
                    if (cell.childNodes[0].type == 'text' || cell.childNodes[0].nodeName == 'SELECT' || cell.childNodes[0].type == 'number' || cell.childNodes[0].type == 'checkbox') {
                        if (cell.childNodes[0].value != '' || cell.childNodes[0].hasAttribute("multiple")) {
                            if (cell.childNodes[0].hasAttribute("multiple")) {
                                //alert(cell.childNodes[0].id);                             
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                //alert(nodeid);
                                if (nodeid == "pilotprereq") {
                                    var values = $('#pilotprereq' + rowid).val();
                                }
                                else if (nodeid == "csoprereq") {
                                    var values = $('#csoprereq' + rowid).val();
                                }
                                else if (nodeid == "smaprereq") {
                                    var values = $('#smaprereq' + rowid).val();
                                }
                                else if (nodeid == "lmprereq") {
                                    var values = $('#lmprereq' + rowid).val();
                                }
                                //alert(values);
                                arrValues.push(values);
                            }
                            else if (cell.childNodes[0].type == 'checkbox') {
                                var nodeid = cell.childNodes[0].id.replace(/[0-9]/g, '');                             
                                //alert(nodeid);
                                var Pilot = "False";
                                var CSO = "False";
                                var SMA = "False";
                                var LM = "False";
                                //var rowid = cell.childNodes[0].id.slice(-1);
                                var rowid = cell.childNodes[0].id.replace(/[^0-9]/g, '');
                                if (document.getElementById('Pilot' + rowid).checked) {
                                    var Pilot = "True";
                                } else {
                                    var Pilot = "False";
                                }
                                if (document.getElementById('CSO' + rowid).checked) {
                                    var CSO = "True";
                                } else {
                                    var CSO = "False";
                                }
                                if (document.getElementById('SMA' + rowid).checked) {
                                    var SMA = "True";
                                } else {
                                    var SMA = "False";
                                }
                                if (document.getElementById('LM' + rowid).checked) {
                                    var LM = "True";
                                } else {
                                    var LM = "False";
                                }

                                if (nodeid == "Pilot") {
                                    arrValues.push(Pilot);
                                }
                                else if (nodeid == "CSO") {
                                    arrValues.push(CSO);
                                }
                                else if (nodeid == "SMA") {
                                    arrValues.push(SMA);
                                }
                                else if (nodeid == "LM") {
                                    arrValues.push(LM);
                                }

                                //const checkboxArr = [Pilot, CSO, SMA, LM];
                                //alert(checkboxArr);
                                //let checkboxString = checkboxArr.toString();
                                //arrValues.push(checkboxString);
                                //alert("Pilot: " + Pilot + " CSO: " + CSO + " SMA: " + SMA + " LM: " + LM);
                            }
                            else {
                                arrValues.push(cell.childNodes[0].value);
                            }
                        }
                        else {
                            alert("All fields must be filled out!");
                            return;
                        }
                    }
                }
            }
        }
        // The final output.
        //document.getElementById('output').innerHTML = arrValues;
        //alert(arrValues);
        arrValues = arrValues.join("~");
        //alert(arrValues);

        if (arrValues.indexOf('Select Lesson') >= 0) {
            alert("Must select a lesson for every row!");
            return false;
        }
        if (arrValues == "") {
            alert("No row added!");
            return false;
        }

        var templatebuildid = getUrlVars()["buildid"];
        $('#templatetabledata').val(arrValues);
        $('#templatebuildid').val(templatebuildid);
        document.getElementById("savetemplate").submit(); // Submitting form
    }   

    function backtoactivebuilds() {
        window.location.href = "../SOITable/activesoibuilds.aspx";
    }

    function validateSMA(rowCnt) {
        if ($("#SMA" + rowCnt).is(':checked')) {
            $("#CSO" + rowCnt).prop("checked", false);
        }
    }
    function validateCSO(rowCnt) {
        if ($("#CSO" + rowCnt).is(':checked')) {
            $("#SMA" + rowCnt).prop("checked", false);
        }
    }

    function Pilotprereq(rowCnt) {
        var data = $('#pilotprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#pilottd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#pilotprereq' + rowCnt).val();                
                if (data != "") {                    
                    //alert("Selected prereq is not a previous lesson on this build."); 
                    $("#pilottd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            $("#Pilot" + rowCnt).prop("checked", true);
        }
        else {
            $("#Pilot" + rowCnt).prop("checked", false);
        }
    }

    function CSOprereq(rowCnt) {
        var data = $('#csoprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#csotd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#csoprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#csotd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            if ($("#SMA" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#CSO" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#CSO" + rowCnt).prop("checked", false);
        }
    }

    function SMAprereq(rowCnt) {
        var data = $('#smaprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#smatd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#smaprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#smatd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            if ($("#CSO" + rowCnt).is(':checked')) {
                // do nothing
            }
            else {
                $("#SMA" + rowCnt).prop("checked", true);
            }
        }
        else {
            $("#SMA" + rowCnt).prop("checked", false);
        }
    }

    function LMprereq(rowCnt) {
        var data = $('#lmprereq' + rowCnt).val();
        var dataarray = JSON.parse("[" + data + "]");
        $("#lmtd" + rowCnt)[0].style.backgroundColor = 'white';
        for (let j = 0; j < dataarray.length; j++) {
            var prereqbool = 0;
            for (let i = 0; i < rowCnt; i++) {
                var lessonid = $('#lessonsel' + i).val();
                if (lessonid == dataarray[j]) {
                    prereqbool = 1;
                }
            }
            if (prereqbool == 0) {
                data = $('#lmprereq' + rowCnt).val();
                if (data != "") {
                    //alert("Selected prereq is not a previous lesson on this build.");
                    $("#lmtd" + rowCnt)[0].style.backgroundColor = 'red';
                }
            }
        }

        if (data != "") {
            $("#LM" + rowCnt).prop("checked", true);
        }
        else {
            $("#LM" + rowCnt).prop("checked", false);
        }
    }

    function checkmediatype(rowCnt) {
        //alert(rowCnt);
        var lessid = $('#lessonsel' + rowCnt).val();
        var duration = $('#duration' + rowCnt).val();
        var prebrief = $('#prebrief' + rowCnt).val();
        var postbrief = $('#postbrief' + rowCnt).val();
        //alert(lessid);
        if (lessid != "Select Lesson") {
            $.get("../SOITable/getmediatype.aspx?lessid=" + lessid, function (data) {
                const myArray = data.split("<!DOCTYPE html>");
                var data = myArray[0];
                //alert(data);
                if (data == 1) {
                    //alert("This is CAI");   
                    $("#duration" + rowCnt)[0].type = 'text';
                    $("#duration" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#duration" + rowCnt).val('R');
                    $("#duration" + rowCnt).prop("readonly", true);

                    $("#prebrief" + rowCnt)[0].type = 'text';
                    $("#prebrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#prebrief" + rowCnt).val('R');
                    $("#prebrief" + rowCnt).prop("readonly", true);

                    $("#postbrief" + rowCnt)[0].type = 'text';
                    $("#postbrief" + rowCnt)[0].style.backgroundColor = 'lightblue';
                    $("#postbrief" + rowCnt).val('R');
                    $("#postbrief" + rowCnt).prop("readonly", true);
                }
                else {
                    if (duration == 0 || duration == "R") {
                        $("#duration" + rowCnt)[0].type = 'number';
                        $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#duration" + rowCnt).val('0');
                        $("#duration" + rowCnt).prop("readonly", false);
                    }
                    if (prebrief == 0 || prebrief == "R") {
                        $("#prebrief" + rowCnt)[0].type = 'number';
                        $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#prebrief" + rowCnt).val('0');
                        $("#prebrief" + rowCnt).prop("readonly", false);
                    }
                    if (postbrief == 0 || postbrief == "R") {
                        $("#postbrief" + rowCnt)[0].type = 'number';
                        $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                        $("#postbrief" + rowCnt).val('0');
                        $("#postbrief" + rowCnt).prop("readonly", false);
                    }
                }
            });
        }
        else {
            if (duration == 0 || duration == "R") {
                $("#duration" + rowCnt)[0].type = 'number';
                $("#duration" + rowCnt)[0].style.backgroundColor = 'white';
                $("#duration" + rowCnt).val('0');
                $("#duration" + rowCnt).prop("readonly", false);
            }
            if (prebrief == 0 || prebrief == "R") {
                $("#prebrief" + rowCnt)[0].type = 'number';
                $("#prebrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#prebrief" + rowCnt).val('0');
                $("#prebrief" + rowCnt).prop("readonly", false);
            }
            if (postbrief == 0 || postbrief == "R") {
                $("#postbrief" + rowCnt)[0].type = 'number';
                $("#postbrief" + rowCnt)[0].style.backgroundColor = 'white';
                $("#postbrief" + rowCnt).val('0');
                $("#postbrief" + rowCnt).prop("readonly", false);
            }
        }
    }
</script>


<style>

.table-dragable > tbody .grabable { cursor: grab; user-select: none }
.table-dragable > tbody > tr.grabbed {
  box-shadow: 0 0 10px 0 rgba(0,0,0,0.5);
}
.table-dragable > tbody > tr.grabbed:active * {
  cursor: grabbing !important;
}

    table { 
        width: 98%;
        margin: auto;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
        background-color: white;
 -webkit-user-select: auto; /* Safari */
 -ms-user-select: none; /* IE 10+ and Edge */
 user-select: auto; /* Standard syntax */
    }
    table, th, td { 
        border: solid 1px #DDD;
        border-collapse: collapse; 
        padding: 2px 3px; 
        text-align: center;   
    }

.buttonstyle {
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.buttonstyle:focus,
.buttonstyle:hover {
    background-color: #005EB8;
    color: white;
}

.removebutton {
    height: 30px;
    line-height: 3px;
    background-color: transparent;
    font-family: "Poppins", sans-serif;
    border: solid;
    border-color: #005EB8;
    color: black;
    font-weight: 700;
    text-transform: uppercase;
    border-radius: 0.25rem;
    padding: 1rem;
    cursor: pointer;
    margin-left: 30px;
}

.removebutton:focus,
.removebutton:hover {
    background-color: #005EB8;
    color: white;
}
input{
    color: black;
}
.lessonselect{
    width: 400px;
}
.pilotprereqsel{
    width: 400px;
}
.csoprereqsel{
    width: 400px;
}
.smaprereqsel{
    width: 400px;
}
.lmprereqsel{
    width: 400px;
}

.dayinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 50px;
}
.durationinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.prebriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.postbriefinput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.missioninput{
    border: 1px solid;
    font-weight: bold;
    font-size: 20px;
    text-align: center;
    width: 70px;
}
.checkboxlabels{
    width: 100px;
}
.column0{
    width: 156.73px;
    min-width: 132.78px;
}
.column1{
    width: 67.28px;
    min-width: 57px;
}
.column2{
    width: 480.45px;
    min-width: 407px;
}
.column3{
    width: 90.89px;
    min-width: 77px;
}
.column4{
    width: 90.89px;
    min-width: 77px;
}
.column5{
    width: 90.89px;
    min-width: 77px;
}
.column6{
    width: 90.89px;
    min-width: 77px;
}
.column7{
    width: 90.89px;
    min-width: 77px;
}
.column8{
    width: 480.45px;
    min-width: 407px;
}
.column9{
    width: 90.89px;
    min-width: 77px;
}
.column10{
    width: 480.45px;
    min-width: 407px;
}
.column11{
    width: 90.89px;
    min-width: 77px;
}
.column12{
    width: 480.45px;
    min-width: 407px;
}
.column13{
    width: 90.89px;
    min-width: 77px;
}
.column14{
    width: 480.58px;
    min-width: 407px;
}
.cbclass{
    width: 25px;
    height: 25px;
}
</style>

<br /><br />
 <div style="text-align: center; font-family:sans-serif;"><h1>Edit SOI Build<br /><span style="color: #005EB8"></span></h1></div>
<hr />
<button style="margin-left: 20px; margin-top: 4px;" class="button" onclick="backtoactivebuilds()">&#11164; Back to Active SOI Builds</button>
<br /><br />
    <div id="SOITable">   
  
    <table style="width: 98%; min-width: 1614.78px; background-color: #005EB8; color: white;">
    <thead>
    <tr>
    <th class="column0"></th>
    <th class="column1">Day</th>
    <th class="column2">Lesson</th>
    <th class="column3">Duration</th>
    <th class="column4">Pre Brief</th>
    <th class="column5">Post Brief</th>
    <th class="column6"># of Missions</th>
    <th class="column7">Pilot</th>
    <th class="column8">Pilot Prereqs</th>
    <th class="column9">CSO</th>
    <th class="column10">CSO Prereqs</th>
    <th class="column11">SMA</th>
    <th class="column12">SMA Prereqs</th>
    <th class="column13">LM</th>
    <th class="column14">LM Prereqs</th>
    </tr>
    </thead>
    </table>
    <div id="cont"></div>   <!--the container to add the table.-->
    <br />
    <input type="button" style="margin-top: 10px;" class="buttonstyle" id="addRow" value="Add New Row" onclick="addRow()" />  
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt" value="Update Build" onclick="submit()" />
    <input type="button" style="margin-left: 0px;" class="buttonstyle" id="bt2" value="Save Template" onclick="submit2()" />
    <p id='output'></p>
    </div>

<br /><br /><br /><br /><br /><br />

<form name="savedata" id="savedata" method="post" enctype="multipart/form-data" action="../SOITable/editbuild.aspx">
    <input style="width: 2000px;" type="hidden" id="tabledata" name="tabledata" />
    <input type="hidden" id="buildid" name="buildid" />
</form>

<form name ="savetemplate" id="savetemplate" method="post" enctype="multipart/form-data" action="../SOITable/edittemplate.aspx">
    <input type="hidden" id="templatetabledata" name="templatetabledata" />
    <input type="hidden" id="templatebuildid" name="templatebuildid" />
</form>

