﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.IO;
using System.Data.SqlClient;
using System.Configuration;
using System.Web.UI.WebControls;

namespace CAE_WEB_PROJECT.calendar
{
    public class getCalendardata : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            context.Response.Expires = -1;
            IList<CalendarDTO> tasksList = new List<CalendarDTO>();

            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand("SELECT * from CalEvents");
            cmd.Connection = con;
            SqlDataReader reader = cmd.ExecuteReader();
            {
                while (reader.Read())
                {
                    string id = reader["id"].ToString();
                    string title = reader["title"].ToString();
                    string startdate = reader["startdate"].ToString();
                    var startdatetime = DateTime.Parse(startdate);
                    startdate = startdatetime.ToString("yyyy-MM-dd");
                    string enddate = reader["enddate"].ToString();
                    var enddatetime = DateTime.Parse(enddate);
                    enddatetime = enddatetime.AddDays(1);
                    enddate = enddatetime.ToString("yyyy-MM-dd");
                    string starttime = reader["starttime"].ToString();
                    string endtime = reader["endtime"].ToString();
                    string timetitle = " (" + starttime + " - " + endtime + ")";
                    if (starttime != "")
                    {
                        title = title + timetitle;
                    }
                    string eventtype = reader["eventtype"].ToString();
                    string color = "";
                    string textColor = "";
                    if (eventtype == "Meeting")
                    {
                        color = "maroon";
                        textColor = "white";
                    }
                    else if (eventtype == "Conference")
                    {
                        color = "darkorange";
                        textColor = "black";
                    }
                    else if (eventtype == "Time Off")
                    {
                        color = "darkblue";
                        textColor = "white";
                    }
                    else //Holiday
                    {
                        color = "purple";
                        textColor = "white";
                    }

                    tasksList.Add(new CalendarDTO
                    {
                        id = id,
                        title = title,
                        start = startdate,
                        end = enddate,
                        url = "../calendar/showeventdata.aspx?id=" + id,
                        color = color,
                        textColor = textColor
                    });
                }
            }

            System.Web.Script.Serialization.JavaScriptSerializer oSerializer =
            new System.Web.Script.Serialization.JavaScriptSerializer();
            string sJSON = oSerializer.Serialize(tasksList);
            context.Response.Write(sJSON);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
        public class CalendarDTO
        {
            public string id { get; set; }
            public string title { get; set; }
            public string start { get; set; }
            public string end { get; set; }
            public string url { get; set; }
            public string color { get; set; }
            public string textColor { get; set; }
        }
    }
}