﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class ExportReviewReports : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string cookieName = "dltkn";
            string downloadToken = Request.QueryString[cookieName];
            string instructorid = Request.QueryString["instructorid"];
            string all_spec = Request.QueryString["all"];
            string startdate = Request.QueryString["startdate"];
            string enddate = Request.QueryString["enddate"];
            // TODO: validate those two date values!!!!!!!!!!!
            //string tcprequested = Request.QueryString["tcp"];
            string[] stmtArray = {
                "SELECT lessnumber, lesstitle, lessrev, revdate, review_date, comments, instructorid ",
                "FROM Review r LEFT JOIN Lesson l", // default
                " ON l.lessid = r.lessid",
                "", // WHERE condition (optional)
                " ORDER BY lessnumber, review_date"
            };
            if (all_spec == "reviews")
            {
                // Do nothing; accept the defaults.
                //sqlString = "SELECT * from Review order by review_date";
            }
            else if (all_spec == "lessons")
            {
                stmtArray[1] = "FROM Lesson l LEFT JOIN Review r";
            }
            else if (instructorid != null)
            {
                //sqlString = "SELECT * from Review where instructorid=" + instructorid + " order by review_date";
                stmtArray[3] = " where instructorid=" + instructorid;
            }
            else if (startdate != null)
            {
                //sqlString = "SELECT * from Review where review_date between '" + startdate + "' and '" + enddate + "' order by review_date";
                stmtArray[3] = $" where review_date between '{startdate}' and '{enddate}'";
            }
            /*else if (tcprequested != null)
            {
                //sqlString = "SELECT * from Review where tcp=" + tcprequested + " order by review_date";
                stmtArray[3] = " where tcp=" + tcprequested;
            }*/
            else
            {
                // Don't write a diagnostic message, because this could be someone sending a hacked URL.
                // TODO: test this and see if it leaves a new window/tab open - we would want to close that
                // Postscript: I believe there would only be such if the user had configured their browser to
                // automatically open a downloaded Excel file in a new window/tab.
                // But we have not even started the process yet here, so the concern does not apply.
                return;
            }

            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {
                var worksheet = excel.Workbook.Worksheets.Add("REVIEWREPORT"); // Label the worksheet tab
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "LESSON ID", "LESSON NAME", "REVIEW DATE","INSTRUCTOR","COMMENTS" }//"TCP REQUESTED","COMMENTS" }
                  };
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                int rowcounter = 2; // step past the header row, in preparation for adding data rows

                DbToWeb myConverter = new DbToWeb();
                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
                SqlConnection con = new SqlConnection(cs);
                con.Open();

                SqlCommand cmd = new SqlCommand(String.Join("", stmtArray));
                cmd.Connection = con;
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    while (reader.Read())
                    {
                        string revCode = myConverter.getRevName(reader["lessrev"].ToString(), cs);
                        string revDate = myConverter.interpretDate(reader["revdate"].ToString());
                        string lessonId = reader["lessnumber"].ToString();
                        string[] lessonData = {
                            reader["lesstitle"].ToString(),
                            revCode != "" ? (" | REV " + revCode) : "", // some lessons have "-" or no rev
                            revDate != "" ? (" | " + revDate) : "" // some lessons have no rev date
                        };
                        string lessonName = String.Join("", lessonData);
                        string reviewDate = myConverter.interpretDate(reader["review_date"].ToString());
                        string comments = reader["comments"].ToString();
                        string instructor = myConverter.identifyMember(reader["instructorid"].ToString(), cs);
                        /*
                        string tcp = reader["tcp"].ToString();
                        string tcpname = "";
                        if (tcp == "1")
                        {
                            tcpname = "Yes";
                        }
                        else
                        {
                            tcpname = "No";
                        }
                        */

                        //Table Rows
                        //Now add some data in rows for each column
                        var Data = new List<object[]>()
                            {
                              new object[] { lessonId, lessonName, reviewDate, instructor, comments }, //tcpname, comments },
                            };
                        worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                        rowcounter++;
                    }
                }
                con.Dispose();

                //worksheet.Cells[worksheet.Dimension.Address].AutoFitColumns(); // This does not suit our needs, IMHO
                // Explicitly set column widths:
                worksheet.Column(1).Width = 16;    // LESSON ID
                worksheet.Column(2).Width = 44;    // LESSON NAME
                worksheet.Column(2).Style.WrapText = true;
                worksheet.Column(3).Width = 12.5;  // REVIEW DATE
                worksheet.Column(4).Width = 30;    // INSTRUCTOR
                worksheet.Column(5).Width = 60;    // COMMENTS
                worksheet.Column(5).Style.WrapText = true;

                //Save Excel file
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/REVIEWREPORT.xlsx"));
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/REVIEWREPORT.xlsx"));
            /*
            // This is only needed if the excel workbook generation takes such a long time that we have to
            // disable the front end while it waits, then re-enable it when the server gets the cookie to
            // the browser with the download.
            // But we seem to have mitigated the long wait problem.
            if (!String.IsNullOrEmpty(downloadToken))
            {
                HttpCookie dlCookie = new HttpCookie(cookieName);
                DateTime now = DateTime.Now;
                dlCookie.Path = "/";
                dlCookie.Value = downloadToken;
                dlCookie.Expires = now.AddHours(1);
                Response.Cookies.Add(dlCookie);
            }
            */
            Response.Redirect("../files/REVIEWREPORT.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}