﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.Configuration;
using System.Text;
using OfficeOpenXml;

namespace CAE_WEB_PROJECT.CAT
{
    public partial class ExportReviewReportsLessons : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string lessonids = Request.QueryString["lessid"];

            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;
            using (ExcelPackage excel = new ExcelPackage())
            {

                //Add Worksheets in Excel file
                excel.Workbook.Worksheets.Add("REVIEWREPORT");
                var worksheet = excel.Workbook.Worksheets["REVIEWREPORT"];
                var headerLabels = new List<string[]>()
                  {
                    new string[] { "LESSON","REVIEW DATE","INSTRUCTOR","TCP REQUESTED","COMMENTS" }
                  };
                string Range = "A1:" + Char.ConvertFromUtf32(headerLabels[0].Length + 64) + "1";
                var headerCells = worksheet.Cells[Range];
                headerCells.LoadFromArrays(headerLabels);
                headerCells.Style.Fill.PatternType = OfficeOpenXml.Style.ExcelFillStyle.Solid;
                headerCells.Style.Fill.BackgroundColor.SetColor(System.Drawing.Color.DeepSkyBlue);
                worksheet.View.FreezePanes(2, 1); // Freeze the header cells row

                //Create Excel file in Uploads folder of your project
                FileInfo excelFile = new FileInfo(Server.MapPath("~/files/REVIEWREPORT.xlsx"));

                int rowcounter = 2;

                string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
  
                if (lessonids != null)
                {
                    if (lessonids.Contains(","))
                    {
                        List<string> listOfLessons = new List<string>(lessonids.Split(','));
                        for (int i = 0; i < listOfLessons.Count; i++)
                        {
                            SqlConnection con3 = new SqlConnection(cs);
                            con3.Open();
                            SqlCommand cmd3 = new SqlCommand("SELECT * from Review where lessid=" + listOfLessons[i] + " order by review_date");
                            cmd3.Connection = con3;
                            SqlDataReader reader3 = cmd3.ExecuteReader();
                            {
                                while (reader3.Read())
                                {
                                    string lessid = reader3["lessid"].ToString();
                                    string lessname = "";
                                    SqlConnection con5 = new SqlConnection(cs);
                                    con5.Open();
                                    SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                                    cmd5.Connection = con5;
                                    SqlDataReader reader5 = cmd5.ExecuteReader();
                                    {
                                        while (reader5.Read())
                                        {
                                            string lessnumber = reader5["lessnumber"].ToString();
                                            string lesstitle = reader5["lesstitle"].ToString();
                                            lessname = lessnumber + " | " + lesstitle;
                                        }
                                    }
                                    con5.Dispose();

                                    string review_date = reader3["review_date"].ToString();
                                    if (review_date == "1/1/1900 12:00:00 AM")
                                    {
                                        review_date = "";
                                    }
                                    if (review_date != "")
                                    {
                                        var review_date_DateTime = DateTime.Parse(review_date);
                                        review_date = review_date_DateTime.ToString("MM/dd/yyyy");
                                    }
                                    string tcp = reader3["tcp"].ToString();
                                    string tcpname = "";
                                    if (tcp == "1")
                                    {
                                        tcpname = "Yes";
                                    }
                                    else
                                    {
                                        tcpname = "No";
                                    }
                                    string comments = reader3["comments"].ToString();
                                    string instid = reader3["instructorid"].ToString();
                                    string instructorname = "";
                                    SqlConnection con4 = new SqlConnection(cs);
                                    con4.Open();
                                    SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instid);
                                    cmd4.Connection = con4;
                                    SqlDataReader reader4 = cmd4.ExecuteReader();
                                    {
                                        while (reader4.Read())
                                        {
                                            string firstname = reader4["firstname"].ToString();
                                            string lastname = reader4["lastname"].ToString();
                                            string username = reader4["username"].ToString();
                                            instructorname = lastname + "," + firstname + " (" + username + ")";
                                        }
                                    }
                                    con4.Dispose();

                                    var Data = new List<object[]>()
                            {
                              new object[] { lessname, review_date, instructorname, tcpname, comments},
                            };
                                    worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                                    worksheet.Cells[worksheet.Dimension.Address].AutoFitColumns();
                                    rowcounter++;
                                }
                            }
                            con3.Dispose();
                        }     
                    }
                    else
                    {
                        SqlConnection con3 = new SqlConnection(cs);
                        con3.Open();
                        SqlCommand cmd3 = new SqlCommand("SELECT * from Review where lessid=" + lessonids + " order by review_date");
                        cmd3.Connection = con3;
                        SqlDataReader reader3 = cmd3.ExecuteReader();
                        {
                            while (reader3.Read())
                            {
                                string lessid = reader3["lessid"].ToString();
                                string lessname = "";
                                SqlConnection con5 = new SqlConnection(cs);
                                con5.Open();
                                SqlCommand cmd5 = new SqlCommand("SELECT * from lesson where lessid=" + lessid);
                                cmd5.Connection = con5;
                                SqlDataReader reader5 = cmd5.ExecuteReader();
                                {
                                    while (reader5.Read())
                                    {
                                        string lessnumber = reader5["lessnumber"].ToString();
                                        string lesstitle = reader5["lesstitle"].ToString();
                                        lessname = lessnumber + " | " + lesstitle;
                                    }
                                }
                                con5.Dispose();

                                string review_date = reader3["review_date"].ToString();
                                if (review_date == "1/1/1900 12:00:00 AM")
                                {
                                    review_date = "";
                                }
                                if (review_date != "")
                                {
                                    var review_date_DateTime = DateTime.Parse(review_date);
                                    review_date = review_date_DateTime.ToString("MM/dd/yyyy");
                                }
                                string tcp = reader3["tcp"].ToString();
                                string tcpname = "";
                                if (tcp == "1")
                                {
                                    tcpname = "Yes";
                                }
                                else
                                {
                                    tcpname = "No";
                                }
                                string comments = reader3["comments"].ToString();
                                string instid = reader3["instructorid"].ToString();
                                string instructorname = "";
                                SqlConnection con4 = new SqlConnection(cs);
                                con4.Open();
                                SqlCommand cmd4 = new SqlCommand("SELECT * from members where id=" + instid);
                                cmd4.Connection = con4;
                                SqlDataReader reader4 = cmd4.ExecuteReader();
                                {
                                    while (reader4.Read())
                                    {
                                        string firstname = reader4["firstname"].ToString();
                                        string lastname = reader4["lastname"].ToString();
                                        string username = reader4["username"].ToString();
                                        instructorname = lastname + "," + firstname + " (" + username + ")";
                                    }
                                }
                                con4.Dispose();

                                var Data = new List<object[]>()
                                {
                                  new object[] { lessname, review_date, instructorname, tcpname, comments},
                                };
                                worksheet.Cells[rowcounter, 1].LoadFromArrays(Data);
                                // Removed AutoFitColumns() from here
                                rowcounter++;
                            }
                        }
                        con3.Dispose();
                    }
                }

                worksheet.Column(1).Width = 60;    // LESSON
                worksheet.Column(1).Style.WrapText = true;
                worksheet.Column(2).Width = 12.5;  // REVIEW DATE
                worksheet.Column(3).Width = 30;    // INSTRUCTOR
                worksheet.Column(4).Width = 12.5;  // TCP REQUESTED
                worksheet.Column(5).Width = 60;    // COMMENTS
                worksheet.Column(5).Style.WrapText = true;

                //Save Excel file
                excel.SaveAs(excelFile);
            }
            byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/files/REVIEWREPORT.xlsx"));
            Response.Redirect("../files/REVIEWREPORT.xlsx", false);
            Context.ApplicationInstance.CompleteRequest();
        }
    }
}