﻿<%@ Page Title="Review Reports" Language="C#" MasterPageFile="~/Header.Master" AutoEventWireup="true" CodeBehind="ReviewReports.aspx.cs" Inherits="CAE_WEB_PROJECT.CAT.ReviewReports" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

<link rel="stylesheet" type="text/css" href="../styles/main.css" />
<link rel="stylesheet" type="text/css" href="../styles/jquery-ui.css" />
<script type="text/javascript" src="../scripts/jquery-3.5.1.js"></script>
<script type="text/javascript" src="../scripts/select2.min.js"></script>
<link rel="stylesheet" href="../styles/select2.min.css" /> 
<script type="text/javascript" src="../scripts/main.js"></script>    
<script type="text/javascript" src="../scripts/jquery-ui.min.js"></script>
<script type="text/javascript" src="../scripts/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="../styles/jquery.dataTables.css" /> 

<script>
    let currentForm = null;

    $(document).ready(function () {
        const tableDiv = document.getElementById('tablediv');
        const querySelect = document.getElementById("queryselect");
        const qsLookup = getUrlVars();

        let isPreselected = (() => {
            let qid = '';
            const allReviews = qsLookup['all'];
            if (!allReviews) return false;
            if (allReviews == 'reviews')
                qid = 'allReviews';
            else if (allReviews == 'lessons')
                qid = 'allLessons';
            else {
                console.error(`Unrecognized value '${allReviews}' for 'all' in query string`);
                return false;
            }
            querySelect.value = qid;
            currentForm = document.getElementById(qid);
            return true;
        })();

        if (!isPreselected) {
            isPreselected = (() => {
                const lessid = qsLookup["lessid"];
                if (!lessid) return false;
                //alert(lessid);
                const qid = 'bylesson';
                querySelect.value = qid;
                currentForm = document.getElementById(qid);
                // When multiple lessons are selected and found, lessid is a comma-delimited string of Ids.
                if (!lessid.match(/^[1-9][0-9]*(?:,[1-9][0-9]*)*$/)) {
                    // TODO: evaluate this...
                    // It turns out that a non-matching lessid string (in the URL sent to the server) will
                    // crash the C# code before this code can be loaded!
                    // Still, it *may* be worth checking it here depending on how we deal with it in the C#.
                    console.error('Bad lessid value in query string:', lessid);
                    return false;
                }
                const myData = lessid.split(',');
                setTimeout(function () {
                    $('#lessonsel').select2().val(myData).trigger('change');
                }, 0);
                return true;
            })();
        }

        if (!isPreselected) {
            isPreselected = (() => {
                const instructorid = qsLookup["instructorid"];
                if (!instructorid) return false;
                const qid = 'byinstructor';
                querySelect.value = qid;
                currentForm = document.getElementById(qid);
                document.getElementById("instructors").value = instructorid;
                return true;
            })();
        }

        if (!isPreselected) {
            isPreselected = (() => {
                const startdate = qsLookup["startdate"];
                const enddate = qsLookup["enddate"];
                if (!startdate || !checkDate(startdate) || !checkDate(enddate)) return false;
                // TODO: is it ever OK for enddate to be empty? Check to see what happens on submission...
                const qid = 'bydaterange';
                querySelect.value = qid;
                currentForm = document.getElementById(qid);
                document.getElementById("start_date").value = startdate;
                document.getElementById("end_date").value = enddate;
                return true;
            })();
        }

        /*
        if (!isPreselected) {
            isPreselected = (() => {
                const tcprequested = qsLookup["tcp"];
                if (tcprequested == undefined) return false;
                const qid = 'bytcp';
                querySelect.value = qid;
                currentForm = document.getElementById(qid);
                document.getElementById("tcpselect").value = tcprequested;
                return true;
            })();
        }
        */

        if (isPreselected) {
            currentForm.style.display = "inline";
            tableDiv.style.visibility = "visible";
        }

        $("#instructors").select2();
        $("#lessonsel").select2();

        $(function () {
            $("#start_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
            $("#end_date").datepicker({
                changeMonth: true,
                changeYear: true
            });
        });

        $('#example').dataTable({
            "order": [],
            "bPaginate": false,
            "bLengthChange": false,
            "bFilter": true,
            "bInfo": true,
            "bAutoWidth": true,
            "scrollY": "400px",
            "sScrollX": "100%",
            "sScrollXInner": "100%",
            "scrollCollapse": true,
            "language": {
                "emptyTable": "No Reviews"
            }
        });

        var table = $('#example').DataTable();

        $('#example tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selid = null;
            }
            else {
                table.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });  
    });

    function getUrlVars() {
        var vars = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
            vars[key] = value;
        });
        return vars;
    }

    function selectquery() {
        const queryId = document.getElementById("queryselect").value;
        if (!queryId) return; // The prompt item was selected

        const reqForm = document.getElementById(queryId);
        if (!reqForm) {
            console.error(`Bad value '${queryId}' in the query select list: no query form has that id`);
            return;
        }

        document.getElementById("tablediv").style.visibility = "hidden";
        if (currentForm && currentForm !== reqForm) {
            currentForm.style.display = 'none';
        }
        currentForm = reqForm;
        currentForm.style.display = 'inline';
    }

    function alllessonsreport(opt) {
        if (opt != 'lessons' && opt != 'reviews') {
            console.error(`Unrecognized all-lessons option "${opt}"`)
            return;
        }
        window.location.href = "../CAT/ReviewReports.aspx?all=" + opt;
    }

    function lessonreport() {
        var e = document.getElementById("lessonsel");
        var value = e.value;
        if (value == 0) {
            alert("Lesson(s) field is required.");
            return false;
        }
        var values = $('#lessonsel').val();
        //alert(values);
        window.location.href = "../CAT/ReviewReports.aspx?lessid=" + values; 
    }

    function instructorreport() {
        var e = document.getElementById("instructors");
        var value = e.value;
        if (value == 0) {
            alert("Instructor field is required.");
            return false;
        }
        window.location.href = "../CAT/ReviewReports.aspx?instructorid=" + value;       
    }

    function rangedatereport() {
        var startdate = document.getElementById("start_date").value;
        var enddate = document.getElementById("end_date").value;

        if (startdate == "") {
            alert("Start Date field is required.");
            return false;
        }
        if (checkstartdate() == false) return false;
        if (enddate == "") {
            alert("End Date field is required.");
            return false;
        }  
        if (checkenddate() == false) return false;
        if (startdate > enddate) {
            alert("Error: Start Date must come before End Date.");
            return false;
        }
        window.location.href = "../CAT/ReviewReports.aspx?startdate=" + startdate + "&enddate=" + enddate;
    }
    /*
    function tcpreport() {
        var e = document.getElementById("tcpselect");
        var value = e.value;
        if (value == "") {
            alert("TCP Requested field is required.");
            return false;
        }
        window.location.href = "../CAT/ReviewReports.aspx?tcp=" + value;
    }
    */

    function checkDate(dateStr) {
        // Empty string is OK; else we need to analyze it
        if (dateStr) {
            // First check for the pattern
            if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateStr)) {
                return false;
            }

            // Parse the date parts to integers
            const parts = dateStr.split("/");
            const month = parseInt(parts[0], 10);
            const year = parseInt(parts[2], 10);

            // Check the ranges of month and year
            if (year < 1000 || year > 3000 || month == 0 || month > 12) {
                return false;
            }
        }
        return true;
    }

    function checkstartdate() {
        const startdate = document.getElementById("start_date").value;
        if (!checkDate(startdate)) {
            alert("ERROR: Date must be valid!");
            return false;
        }
    }

    function checkenddate() {
        const enddate = document.getElementById("end_date").value;
        if (!checkDate(enddate)) {
            alert("ERROR: Date must be valid!");
            return false;
        }
    }

    function getCookie(name) { // verified: this does the trick
        const parts = document.cookie.split(name + '=');
        return (parts.length == 2) ? parts.pop().split(';').shift() : '';
    }

    // Not currently using this, but keep it just in case
    function beginBigExportRequest(urlPrefix) {
        const dlCookieName = 'dltkn';
        const downloadToken = new Date().getTime();
        const excelBtn = document.getElementById('toExcel');
        const waitMask = document.getElementById('waitMask');
        excelBtn.disabled = true;
        waitMask.style.visibility = 'visible';
        $('#patience').css('visibility', 'visible');

        const downloadTimer = window.setInterval(function () {
            if (getCookie(dlCookieName) == downloadToken) {
                window.clearInterval(downloadTimer);
                $('#patience').css('visibility', '');
                waitMask.style.visibility = '';
                excelBtn.disabled = false;
                // expire cookie immediately
                document.cookie = dlCookieName + "=deleted; expires=" + new Date(0).toUTCString();
            }
        }, 1000); // Check once per second

        window.location.href = `${urlPrefix}&${dlCookieName}=${downloadToken}`;
    }

    function exportexcel() {
        const qsLookup = getUrlVars();

        const allVal = qsLookup["all"];
        if (allVal) {
            /*
            // This is only needed if the excel workbook generation takes such a long time that we have to
            // disable the front end while it waits, then re-enable it when the server gets the cookie to
            // the browser with the download.
            // But we seem to have mitigated the long wait problem.
            if (allVal == 'lessons') {
                if (!window.confirm("This can take a very long time to generate.\nAre you sure you want to continue?"))
                    return;
            }
            beginBigExportRequest('../CAT/ExportReviewReports.aspx?all=' + allVal);
            */
            window.location.href = '../CAT/ExportReviewReports.aspx?all=' + allVal;
        }

        var lessid = qsLookup["lessid"];
        if (lessid != undefined) {
            window.location.href = "../CAT/ExportReviewReportsLessons.aspx?lessid=" + lessid;
        }

        var instructorid = qsLookup["instructorid"];
        if (instructorid != undefined) {
            window.location.href = "../CAT/ExportReviewReports.aspx?instructorid=" + instructorid;
        }

        var startdate = qsLookup["startdate"];
        var enddate = qsLookup["enddate"];
        // TODO: shouldn't we also check enddate? or was the intention to allow open-ended? See what ExportReviewReports.aspx does with it.
        if (startdate != undefined) {
            window.location.href = "../CAT/ExportReviewReports.aspx?startdate=" + startdate + "&enddate=" + enddate;
        }
        /*
        var tcprequested = qsLookup["tcp"];
        if (tcprequested != undefined) {
            window.location.href = "../CAT/ExportReviewReports.aspx?tcp=" + tcprequested;
        }
        */
    }
</script>

<style>
.reporttype{
    text-align: center;
    width: 450px;
    background-color: navajowhite;
    margin: auto;
    border: 2px solid black;
    padding: 10px;
    border-radius: 20px;
}
.select2-search__field {
    color: black;
}
#queryselect{
    font-size: 18px;
}
#tcpselect{
    font-size: 18px;
}
#start_date{
    font-size: 18px;
    width: 120px;
}
#end_date{
    font-size: 18px;
    width: 120px;
}
#toExcel {
    cursor: pointer;
}
#patience {
    font-size: larger;
    font-weight: bold;
    color: #c00000;
    visibility: hidden;
}
#waitMask {
    position: absolute;
    left: 0;  top: 0;
    width: 100%; height: 100%;
    cursor: wait;
    visibility: hidden;
}
</style>
<br /><br />
<div style="position: relative;"><!-- this will contain the Review Reports content, especially the interactive elements -->
    <div style="text-align: center; font-family:sans-serif;"><h1>Review Reports</h1></div>
    <hr />
    <br />
    <div class="reporttype">
        <select id="queryselect" onchange="selectquery();">
            <option value="">Select Query Type</option>
            <option value="allReviews">All Reviews</option>
            <option value="allLessons">All Lessons</option>
            <option value="bylesson">Search By Lesson(s)</option>
            <option value="byinstructor">Search By Instructor</option>
            <option value="bydaterange">Search By Date Range</option>
            <!--option value="bytcp">Search By TCP Requested</option-->
        </select>

        <div id="allReviews" style="display: none;">
            <br /><br />
            <b>Search All Reviews</b><br /><br />
            <button class="button" onclick="alllessonsreport('reviews');">Submit</button>
        </div>

        <div id="allLessons" style="display: none;">
            <br /><br />
            <b>Search All Lessons</b><br /><br />
            <button class="button" onclick="alllessonsreport('lessons');">Submit</button>
        </div>

        <div id="bylesson" style="display: none;">
            <br /><br />
            <b>Search By Lesson(s)</b><br /><br />
            <select id="lessonsel" style="width: 400px;" multiple>
                <asp:Label ID="Label2" runat="server" />
            </select>
            <br /><br />
            <button class="button" onclick="lessonreport();">Submit</button>
        </div>

        <div id="byinstructor" style="display: none;">
            <br /><br />
            <b>Search By Instructor</b><br /><br />
            <select id="instructors" style="width: 400px;">
                <asp:Label ID="Label1" runat="server" />
            </select>
            <br /><br />
            <button class="button" onclick="instructorreport();">Submit</button>
        </div>

        <div id="bydaterange" style="display: none;">
            <br /><br />
            <b>Search By Date Range</b><br /><br />
            <input id="start_date" name="start_date" type="text" placeholder="Start Date" style="color: black" autocomplete="off" onchange="checkenddate();" />
            <input id="end_date" name="end_date" type="text" placeholder="End Date" style="color: black" autocomplete="off" onchange="checkstartdate();" />
            <br /><br />
            <button class="button" onclick="rangedatereport();">Submit</button>
        </div>

        <!--div id="bytcp" style="display: none;">
            <br /><br />
            <b>Search By TCP Requested</b><br /><br />
            <select id="tcpselect">
                <option value="">TCP Requested</option>
                <option value="0">No</option>
                <option value="1">Yes</option>
            </select>
            <br /><br />
            <button class="button" onclick="tcpreport();">Submit</button>
        </div-->
    </div>

    <div id="tablediv" style="visibility:hidden; margin: 35px;">
        <button id="toExcel" onclick="exportexcel();"><img src="../images/excel.png" width="32" height="30" title="Export to Excel" /></button>
        <span id="patience">Working; please be patient...</span>
        <table id="example" class="display" style="border: none">
            <thead style="background-color: #005EB8; color: white">
                <tr>
                    <th style="width: 100px; min-width: 100px;">Lesson</th>
                    <th style="width: 50px; min-width: 50px;">Review Date</th>
                    <th style="width: 100px; min-width: 100px;">Instructor</th>
                    <!--th style="width: 50px; min-width: 50px;">TCP Requested</th-->
                    <th style="width: 400px; min-width: 400px;">Comments</th>
                </tr>
            </thead>
            <tbody>
                <asp:Label ID="Label3" runat="server" />
            </tbody>
        </table>
    </div>
    <div id="waitMask"></div>
</div>

</asp:Content>
