﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Web.Script.Serialization;
using Org.BouncyCastle.Ocsp;
using System.ServiceModel.Syndication;
using System.Web.UI.HtmlControls;

namespace CAE_WEB_PROJECT.CAT
{
    /// <summary>
    /// Summary description for getlessons
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [System.Web.Script.Services.ScriptService]
    public class getlessons : System.Web.Services.WebService
    {
        private Dictionary<string,string> revCache = new Dictionary<string,string>();
        private Dictionary<string,string> mediaCache = new Dictionary<string,string>();
        private Dictionary<string,string> subtypeCache = new Dictionary<string,string>();
        private Dictionary<string,string> statusCache = new Dictionary<string,string>();
        private Dictionary<string,string> classCache = new Dictionary<string,string>();
        private Dictionary<string,string> mpCache = new Dictionary<string,string>();

        private void buildSimpleDictionary(Dictionary<string,string> dict, string cs, string tableName, string col1, string col2)
        {
            SqlConnection con = new SqlConnection(cs);
            con.Open();
            SqlCommand cmd = new SqlCommand($"SELECT {col1}, {col2} from {tableName}");
            cmd.Connection = con;
            SqlDataReader rdr = cmd.ExecuteReader();
            {
                while (rdr.Read())
                {
                    dict.Add(rdr[col1].ToString(), rdr[col2].ToString());
                }
            }
            con.Dispose();
        }

        private string doLookup(string key, Dictionary<string, string> dict, string cs, string tableName, string col1, string col2)
        {
            string value = "";
            if (!string.IsNullOrEmpty(key))
            {
                if (dict.Count == 0)
                {
                    this.buildSimpleDictionary(dict, cs, tableName, col1, col2);
                }
                if (dict.ContainsKey(key)) value = dict[key];
            }
            return value;
        }

        private string getRevName(string revId, string cs)
        {
            return doLookup(revId, revCache, cs, "REVIku", "Id", "REV");
        }

        private string getMediaName(string mediaId, string cs)
        {
            return doLookup(mediaId, mediaCache, cs, "MEDIAIku", "Id", "MEDIA");
        }

        private string getSubtypeName(string typeId, string cs)
        {
            return doLookup(typeId, subtypeCache, cs, "Subtypes", "Id", "subtype");
        }

        private string getStatusName(string statId, string cs)
        {
            return doLookup(statId, statusCache, cs, "STATUSIku", "Id", "STATUS");
        }

        private string getClassificationName(string clsId, string cs)
        {
            return doLookup(clsId, classCache, cs, "CLASSIFICATION", "Id", "CLASSIFICATION");
        }

        private string getMpName(string mpId, string cs)
        {
            return doLookup(mpId, mpCache, cs, "MP", "Id", "MP");
        }

        private void setLessonAirframeField(lessons lesson, string name, string value)
        {
            switch (name)
            {
                case "AC130J":
                    lesson.AC130J = value;
                    break;
                case "HC130J":
                    lesson.HC130J = value;
                    break;
                case "MC130J":
                    lesson.MC130J = value;
                    break;
                case "UH1N":
                    lesson.UH1N = value;
                    break;
                case "HH60":
                    lesson.HH60 = value;
                    break;
                case "CV22":
                    lesson.CV22 = value;
                    break;
                case "Ft Rucker":
                    lesson.FTRUCKER = value;
                    break;
            }
        }

        private string getAirframeApplicabilityHtml(string name, string value)
        {
            string result = "";
            // NOTE: AC130J is currently designated as 1st item to display (AIRFRAMEIku.seq == 1).
            // If that ever changes, then so must this:
            if (name != "AC130J")
            {
                // NOTE: the nbsp spacing is necessary to prevent the set of items from wrapping.
                result = "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            result += (value == "True" ? "&#x2611;" : "&#x2610;"); // Checked box icon vs. Unchecked box icon
            result += "&nbsp;" + name.Replace(" ", "&nbsp;");
            return result;
        }

        [WebMethod]
        public void GetLessons()
        {
            string cs = System.Configuration.ConfigurationManager.ConnectionStrings["Database1.mdf"].ConnectionString;
            DbToWeb myConverter = new DbToWeb();
            string[] airframeNames = myConverter.getAirframeNames(cs);
            List<lessons> lessonlist = new List<lessons>();
            using (SqlConnection con = new SqlConnection(cs))
            {
                SqlCommand cmd = new SqlCommand("SELECT * from Lesson");
                cmd.Connection = con;
                con.Open();
                SqlDataReader reader = cmd.ExecuteReader();
                {
                    int afColIndex = -1;
                    try
                    {
                        afColIndex = reader.GetOrdinal("airframes");
                    }
                    catch (IndexOutOfRangeException ex) {
                        // Let it go; we have -1 as a red flag.
                    }

                    while (reader.Read())
                    {
                        lessons lesson = new lessons();
                        lesson.Id = Convert.ToInt32(reader["ID"]);
                        lesson.LESSID = Convert.ToInt32(reader["LESSID"]);
                        lesson.LESSNUMBER = reader["LESSNUMBER"].ToString();
                        lesson.LESSTITLE = reader["LESSTITLE"].ToString();

                        string LESSREV = reader["LESSREV"].ToString();
                        if (LESSREV == "0") // artifact of older version of this project
                        {
                            LESSREV = "";
                        }
                        lesson.REVNUMBER = LESSREV;
                        lesson.REV = this.getRevName(LESSREV, cs);

                        lesson.REVDATE = myConverter.interpretDate(reader["REVDATE"].ToString());
                       
                        string MEDIAIku = reader["MEDIAIku"].ToString();
                        lesson.MEDIANUMBER = MEDIAIku;
                        lesson.MEDIA = this.getMediaName(MEDIAIku, cs);

                        string SUBTYPEID = reader["SUBTYPE"].ToString();
                        if (SUBTYPEID == "0") // artifact of older version of this project
                        {
                            SUBTYPEID = "";
                        }
                        lesson.SUBTYPENUMBER = SUBTYPEID;
                        lesson.SUBTYPE = this.getSubtypeName(SUBTYPEID, cs);

                        lesson.FEADATE = myConverter.interpretDate(reader["FEADATE"].ToString());

                        string STATUS = reader["STATUS"].ToString();
                        lesson.STATUSNUMBER = STATUS;
                        lesson.LESS_STATUS = this.getStatusName(STATUS, cs);
                        
                        string CLASSIFICATION = reader["CLASSIFICATION"].ToString();
                        if (CLASSIFICATION == "0") // artifact of older version of this project
                        {
                            CLASSIFICATION = "";
                        }
                        lesson.CLASSNUMBER = CLASSIFICATION;
                        lesson.LESS_CLASSIFICATION = this.getClassificationName(CLASSIFICATION, cs);

                        // So far, ICWL.ICWL is just a number that matches the Id of its record.
                        string ICWL = reader["ICWL"].ToString();
                        lesson.ICWL = ICWL == "0" ? "" : ICWL;
                        //lesson.LESS_DURATION = reader["LESS_DURATION"].ToString();
                      
                        string MP = reader["MP"].ToString();
                        if (MP == "0") // artifact of older version of this project
                        {
                            MP = "";
                        }
                        lesson.MPNUMBER = MP;
                        lesson.MP = this.getMpName(MP, cs);

                        //lesson.SPTTIME = reader["SPTTIME"].ToString();
                        lesson.LESSNOTE = reader["LESSNOTE"].ToString();
                        lesson.MESL = reader["MESL"].ToString();

                        List<string> AFChkboxList = new List<string>();
                        AFChkboxList.Add("<div style='display:inline-block;'>");
                        /*
                         * NOTE ABOUT ON-GOING DEVELOPMENT:
                         * For a while there were only six airframes recognized in the DB
                         * (if you don't count the combo "HC/MC", which was never used as far as I have seen...)
                         * So, at the initial design time, it seemed reasonable to have a fixed set of columns
                         * representing per-airframe applicability in a Lesson record.
                         * But then the addition of AC130J was requested, which hinted of the possibility that another
                         * airframe addition could be requested at any time in the future.
                         * Design choice: do we keep adding 'bit' fields to the Lesson table for each new airframe,
                         * or can we just have a single int column that we use as a set of bit flags?
                         * Given that a DB int is 32 bits, and only one flag index has been wasted so far
                         * (corresponding to "HC/MC"), we've got plenty of slots for expansion there.
                         * It's just a matter of correctly handling the packing & unpacking of the flags when needed.
                         * This has been encapsulated in the DbToWeb class, so that it's isolated.
                         * Currently we're using both the set of airframe bit columns *and* the int airframes column,
                         * but I expect we'll eventually reach the point when the data is 100% redundant - and then
                         * we'll be able to remove the code that uses/maintains the six airframe bit columns.
                         */
                        try
                        {
                            // We expect that this newly-introduced airframes column will be null for all records that
                            // existed previous to its addition and have not been updated yet.
                            // The following will throw if the airframes value is null, or if afColIndex is still -1:
                            uint airframeFlags = (uint)reader.GetInt32(afColIndex);
                            foreach (string name in airframeNames)
                            {
                                string fieldValue = myConverter.isApplicableAirframe(name, airframeFlags) ? "True" : "";
                                setLessonAirframeField(lesson, name, fieldValue);
                                AFChkboxList.Add(getAirframeApplicabilityHtml(name, fieldValue));
                            }
                        }
                        catch {
                            // Fall back to the separate bit-type columns representing airframes (legacy)
                            foreach (string name in airframeNames)
                            {
                                string field = myConverter.getAirframeColumnName(name);
                                string fieldValue = "";
                                // AC130J is not one of the legacy fields, so trying to get it from the reader will throw
                                try
                                {
                                    fieldValue = reader[field].ToString();
                                }
                                catch (IndexOutOfRangeException)
                                {
                                    // Let it pass; we have a default non-True value.
                                }
                                setLessonAirframeField(lesson, name, fieldValue);
                                AFChkboxList.Add(getAirframeApplicabilityHtml(name, fieldValue));
                            }
                        }
                        AFChkboxList.Add("</div>");

                        lesson.Airframes = string.Join("", AFChkboxList.ToArray());

                        string PRIMARY_INSTRUCTOR_ID = reader["PRIMARY_INSTRUCTOR"].ToString();
                        if (PRIMARY_INSTRUCTOR_ID == "0") // artifact of older version of this project
                        {
                            PRIMARY_INSTRUCTOR_ID = "";
                        }
                        lesson.PRIMARY_INSTRUCTOR_NUMBER = PRIMARY_INSTRUCTOR_ID;
                        lesson.PRIMARY_INSTRUCTOR = myConverter.identifyMember(PRIMARY_INSTRUCTOR_ID, cs);

                        string ALTERNATE_INSTRUCTOR_ID = reader["ALTERNATE_INSTRUCTOR"].ToString();
                        if (ALTERNATE_INSTRUCTOR_ID == "0") // artifact of older version of this project
                        {
                            ALTERNATE_INSTRUCTOR_ID = "";
                        }
                        lesson.ALTERNATE_INSTRUCTOR_NUMBER = ALTERNATE_INSTRUCTOR_ID;
                        lesson.ALTERNATE_INSTRUCTOR = myConverter.identifyMember(ALTERNATE_INSTRUCTOR_ID, cs);

                        lessonlist.Add(lesson);
                    }
                }
                con.Dispose();
            }
            JavaScriptSerializer js = new JavaScriptSerializer();
            js.MaxJsonLength = Int32.MaxValue;
            Context.Response.Write(js.Serialize(lessonlist));
        }
    }
}
